/*
        Testable Blocks Detector
        ====================================
        Source File - tb.cc
        Coded and assembled by: Ing. Tom Herrman <herrman@fitvutbr.cz>
                                UPSY FIT VUT 2006-2008 http://www.fit.vutbr.cz/~herrman
        Date: 02/2008
        Version: 0.9
        
        Licence: This program can be copied and used without limitation only
                 with presentation header and author's name. 
        Thanks to: Yarda for Ruzicka's formal model core
*/

/*
                             ___
                     /======/             
            ____    //      \___       ,/
             | \\  //           :,   ./
     |_______|__|_//            ;:; /
    _L_____________\o           ;;;/
____(CCCCCCCCCCCCCC)____________-/___________________kg__

*/

#define DEBUG
//#define DEBUG_LOOPBREAKREMOVE
//#define SPLIT_DEBUG
//#define VERILOG_DEBUG

#ifndef ivector
#include <vector>
#define ivector
#endif

#include <iostream>
#include "error.h"
#include "ruzic.h"
#include "tb_private.h"
#include "utils.h"
#include <string.h>

// template class for pair sorted by t2
template <class t1,class t2> class t2pair {
public:
  t1 f;                                          // first element
  t2 s;                                          // second element
  t2pair(t1 fi=(t1)0,t2 si=(t2)0)
  {
    f=fi;
    s=si;
  }
  bool operator< (const t2pair p) const          // less operator
  {
    return (s<p.s||(s==p.s)&&(f<p.f));
  }                
};

typedef std::vector<bool, std::allocator<bool> > bit_vector;
typedef double tfitness;
typedef t2pair<bit_vector,tfitness> tchromosom;
typedef map<tid,tpair> tR_TB;
typedef map<tid,tid> tE_TB;
typedef map<tid,unsigned int> tS_TB; // synchronistion pulse number

#define default_population_size 10
#define new_p_size 7
#define crossover_probability 70
#define mutation_probability 1
#define mutation_bits 1
truua uua;
truua uua_sub; // Unit Under Analysis
tid cnt;
timeb tmea;

// some aliases
#define makeOTRV makeCTDR


using namespace std;

void usage(char *pname) {
    cout<<endl;
    cout<<pname<<" unit"<<endl<<endl;
    cout<<"\tunit - filename of unit with .ruz"<<endl;
    return;
}

void other_compute()
{
// find I-paths
  cout<<"Finding I paths...  so far done:  "<<flush;
  uua.findI(cout);
  cout<<endl;
  cout<<"Found I paths : "<<uua.I.size()<<endl;
  cout<<"Found ROs     : "<<uua.RO.size()<<endl;
  cout<<"Found finished @ ";
  cout<<endl<<endl;

// find TDRs
  cout<<"Finding TDRs...                                             "<<flush;
  uua.findTDR();
  cout<<"<Done>"<<endl;
  cout<<"Found: "<<uua.ATDR.size()<<endl;
// find TRVs
  cout<<"Finding TRVs...                                             "<<flush;
  uua.findTRV();
  cout<<"<Done>"<<endl;
  cout<<"Found: "<<uua.ATRV.size()<<endl;
// find TIRs
  cout<<"Finding TIRs...                                             "<<flush;
  uua.findTIR();
  cout<<"<Done>"<<endl;
  cout<<"Found: "<<uua.ATIR.size()<<endl;
// find TORs
  cout<<"Finding TORs...                                             "<<flush;
  uua.findTOR();
  cout<<"<Done>"<<endl;
  cout<<"Found: "<<uua.ATOR.size()<<endl;

// make simple testability check
  if ((bool)(cnt=(tid)uua.check_testable()))
    cout<<"!WARNING! THERE IS MINIMALY ONE UNTESTABLE GATE # "<<cnt<<
    " - CIRCUIT MUST BE MODIFIED"<<endl<<
    "BY USER, SO NOW DOING UNCOMPLETE CALCULATIONS..."<<endl<<endl;

  cout<<"Computing auxiliary sets...                                 "<<flush;
  uua.makeMI();
  uua.makeCTR();
  uua.makeOBS();
  uua.makeCTDR(uua.ATDR,uua.TIR,uua.CTR,uua.CTDR);
  uua.makeOTRV(uua.ATRV,uua.TOR,uua.OBS,uua.OTRV);              // method aliased
  cout<<"<Done>"<<endl;

// compute scan
  cout<<"Computing SCAN...                                           "<<flush;
  uua.makeSCAN();
  cout<<"<Done>"<<endl;
  cout<<"Registers added to SCAN: "<<uua.SCAN.size()<<endl;
  cout<<endl;
}

void roulette(set<tchromosom> &population, set<tchromosom>::iterator &parent1, set<tchromosom>::iterator &parent2)
{
     tfitness fsum=0;
     tfitness f;
     tfitness r;
     set<tchromosom>::iterator it_population;
#ifdef DEBUG    
     bit_vector v;
     bit_vector::iterator it_bit_vector;
#endif
    
     for (it_population=population.begin();it_population!=population.end();it_population++)
     {
        fsum+=it_population->s;
     }
     r=(rand()%int(fsum))+1;
#ifdef DEBUG    
     cout<<"suma>"<<fsum<<", random>"<<r;
     cout<<endl;
#endif
     f=0;
     parent1=population.begin();
     for (it_population=population.begin();f<r;it_population++)
     {
        f+=it_population->s;
        parent1=it_population;
     }
#ifdef DEBUG    
     cout<<"parent1>";
        cout<<parent1->s<<": ";
        v=parent1->f;
        for (it_bit_vector=v.begin();it_bit_vector!=v.end();it_bit_vector++)
            cout<<*it_bit_vector;
        cout<<endl;
#endif
     fsum-=parent1->s;
     r=(rand()%int(fsum))+1;
#ifdef DEBUG    
     cout<<"suma>"<<fsum<<", random>"<<r;
     cout<<endl;
#endif
     f=0;
     parent2=population.begin();
     for (it_population=population.begin();f<r;it_population++)
     {
        if (it_population!=parent1)
        {
          f+=it_population->s;
          parent2=it_population;
        }
     }
#ifdef DEBUG    
     cout<<"parent2>";
        cout<<parent2->s<<": ";
        v=parent2->f;
        for (it_bit_vector=v.begin();it_bit_vector!=v.end();it_bit_vector++)
            cout<<*it_bit_vector;
        cout<<endl;
#endif
}

void crossover(set<tchromosom>::iterator &parent1, set<tchromosom>::iterator &parent2, bit_vector &o1, bit_vector &o2, unsigned reg_count)
{
     unsigned crosspos,i;
     
     crosspos=(rand()%(reg_count-1));
#ifdef DEBUG    
     cout<<"crosspos>"<<crosspos<<endl;
#endif
     o1.clear();
     o2.clear();
     for(i=0;i<=(reg_count-1);i++)
         if(i>crosspos) {
             o1.insert(o1.end(),parent1->f[i]);
             o2.insert(o2.end(),parent2->f[i]);
         } else {
             o1.insert(o1.end(),parent2->f[i]);
             o2.insert(o2.end(),parent1->f[i]);
         }
}

void mutation(bit_vector &o,unsigned reg_count)
{
     unsigned i,bitnum;
     
     for(i=0;i<mutation_bits;i++)
     {
        bitnum=rand()%reg_count;
        o[bitnum]= !o[bitnum];
     }
}

tid port2element(tid port)
{
    tidsetmap::iterator it_psi;
    telset::iterator it_set;
    
    for (it_psi=uua.PSI.begin();it_psi!=uua.PSI.end();it_psi++)
    {
        if(it_psi->second.count(port))
        {
            return it_psi->first;
        }
    }
    return 0;
}

bool isregister(tid id)
{
     return uua.R.count(id);
}

unsigned regposnum(tid id)
{
     telset::iterator it_r;
     unsigned r=0;

     for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
     {
         if (*it_r==id) return r;
         r++;
     }
         
     return r;
}

bool isconnected2PI(tid port_id)
{
     tpairset::iterator it_c;
     
     for (it_c=uua.C.begin();it_c!=uua.C.end();it_c++)
     {
         if (  (uua.PI.count(it_c->f)&&(it_c->s==port_id)) ||
               (uua.PI.count(it_c->s)&&(it_c->f==port_id)) ) return true;
     }
     return false;
}

bool isconnected2PO(tid port_id)
{
     tpairset::iterator it_c;
     
     for (it_c=uua.C.begin();it_c!=uua.C.end();it_c++)
     {
         if (  (uua.PO.count(it_c->f)&&(it_c->s==port_id)) ||
               (uua.PO.count(it_c->s)&&(it_c->f==port_id)) ) return true;
     }
     return false;
}

tid getTBnum(set<tid> &TBnum_used)
{
    tid x;
    for(x=1;TBnum_used.find(x)!=TBnum_used.end();x++);
    TBnum_used.insert(x);
    return x;
}

unsigned compute_TB_split(bit_vector& v, tR_TB &R_TB, tE_TB &E_TB, tS_TB &aS_TB)
{
    telset::iterator it_e, it_e2;
    telset::iterator it_r;
    telset::iterator it_p;
    tro::iterator it_ro;
    tsequence::reverse_iterator rit_seq;
    tsequence::iterator it_seq;
    tid r,elm;
//    tid tb=0;
//    tid oldtb=0;
    tid itb=0;
    tid otb=0;
    unsigned int slength;
    set<tid> TBnum_used;
    set<tid>::iterator it_TBnum_used;
    tS_TB S_TB;
    bool canerase;

#ifdef SPLIT_DEBUG    
    cout<<"V>";              
    for (bit_vector::iterator it_bit_vector=v.begin();it_bit_vector!=v.end();it_bit_vector++)
        cout<<*it_bit_vector;
    cout<<endl;                  
#endif                  
    
    for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
        R_TB[*it_r] = tpair(0,0);
    for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
        E_TB[*it_e] = 0;
    S_TB.clear();
    
    r=0;
    for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
    {
        if (v[r])
        {
        #ifdef SPLIT_DEBUG    
            cout<<"reg "<<*it_r<<": ";
        #endif                  
            itb=0;otb=0;
            for (it_p=uua.PSI[*it_r].begin();it_p!=uua.PSI[*it_r].end();it_p++)
            {
                if(uua.INP.count(*it_p))  // input port
                  if (R_TB[*it_r].f==0)
                  {  
                      canerase=false;
                      if(itb==0)
                      {
                        canerase=true;
                        itb=getTBnum(TBnum_used);
                      }
                  #ifdef SPLIT_DEBUG    
                      cout<<"in-"<<*it_p<<" ";
                  #endif
                      if (isconnected2PI(*it_p))
                      {
                           if(canerase) {
                              for (it_e2=uua.E.begin();it_e2!=uua.E.end();it_e2++)
                                  if (E_TB[*it_e2]==itb) E_TB[*it_e2] = -1;
                              for (it_e2=uua.R.begin();it_e2!=uua.R.end();it_e2++)
                              {
                                  if (R_TB[*it_e2].f==itb) R_TB[*it_e2].f = -1;
                                  if (R_TB[*it_e2].s==itb) R_TB[*it_e2].s = -1;
                              }
                              TBnum_used.erase(itb);
                              S_TB[itb]=0;
//                              itb=0;
                          }
                          itb=-1;
//                          R_TB[*it_r].f=-1/*INT_MAX unsigned(-1)*/;
//                          continue;
                      }
restartsearch1:
                      R_TB[*it_r].f=itb;                      
                      for (it_ro=uua.RO.begin();it_ro!=uua.RO.end();it_ro++)
                          if(it_ro->first.s==*it_p) // is end in our port?
                          {
                          #ifdef SPLIT_DEBUG    
                              cout<<"("<<it_ro->first.f<<",'"<<*it_p<<"'){";
                          #endif
                              slength=0;
                              for (rit_seq=it_ro->second.rbegin();rit_seq!=it_ro->second.rend();rit_seq++)
                                  if(*it_p!=*rit_seq)
                                  {
                                      elm=port2element(*rit_seq);
                                      if(elm==0) { 
                                      #ifdef SPLIT_DEBUG    
                                          cout<<*rit_seq<<"-not element";
                                      #endif
                                          continue;
                                      }
                                      if(!isregister(elm)) {
                                          if(E_TB[elm]>0 && E_TB[elm]!=itb )
                                          {
                                          #ifdef SPLIT_DEBUG    
                                              cout<<"DUPLICATE iE("<<E_TB[elm]<<","<<itb<<"-"<<elm<<")";
                                          #endif
                                              for (it_e2=uua.E.begin();it_e2!=uua.E.end();it_e2++)
                                                  if (E_TB[*it_e2]==itb) E_TB[*it_e2] = 0;                                              
                                              for (it_e2=uua.R.begin();it_e2!=uua.R.end();it_e2++)
                                              {
                                                  if (R_TB[*it_e2].f==itb) R_TB[*it_e2].f = 0;
                                                  if (R_TB[*it_e2].s==itb) R_TB[*it_e2].s = 0;
                                              }
                                              TBnum_used.erase(itb);
                                              S_TB[itb]=0;
                                              itb=E_TB[elm];
                                              goto restartsearch1;
                                          }
                                          E_TB[elm]=itb;
                                      } else {
                                          slength++;
                                          if(v[regposnum(elm)])
                                          {
                                              if(R_TB[elm].s>0 && R_TB[elm].s!=itb )
                                              {
                                              #ifdef SPLIT_DEBUG    
                                                  cout<<"DUPLICATE iR("<<R_TB[elm].s<<","<<itb<<"-"<<elm<<")";
                                              #endif
                                                  for (it_e2=uua.R.begin();it_e2!=uua.R.end();it_e2++)
                                                  {
                                                      if (R_TB[*it_e2].f==itb) R_TB[*it_e2].f = 0;
                                                      if (R_TB[*it_e2].s==itb) R_TB[*it_e2].s = 0;
                                                  }
                                                  for (it_e2=uua.E.begin();it_e2!=uua.E.end();it_e2++)
                                                      if (E_TB[*it_e2]==itb) E_TB[*it_e2] = 0;                                              
                                                  TBnum_used.erase(itb);
                                                  S_TB[itb]=0;
                                                  itb=R_TB[elm].s;
                                                  goto restartsearch1;
                                              }
                                              R_TB[elm].s=itb;
                                              break;                                             
                                          } else {
                                              if(R_TB[elm].f>0 && R_TB[elm].f!=itb ) 
                                              {
                                              #ifdef SPLIT_DEBUG    
                                                  cout<<"DUPLICATE iR1("<<R_TB[elm].f<<","<<itb<<"-"<<elm<<")";
                                              #endif
                                                  for (it_e2=uua.R.begin();it_e2!=uua.R.end();it_e2++)
                                                  {
                                                      if (R_TB[*it_e2].f==itb) R_TB[*it_e2].f = 0;
                                                      if (R_TB[*it_e2].s==itb) R_TB[*it_e2].s = 0;
                                                  }
                                                  for (it_e2=uua.E.begin();it_e2!=uua.E.end();it_e2++)
                                                      if (E_TB[*it_e2]==itb) E_TB[*it_e2] = 0;                                              
                                                  TBnum_used.erase(itb);
                                                  S_TB[itb]=0;
                                                  itb=R_TB[elm].f;
                                                  goto restartsearch1;
                                              }
                                              if(R_TB[elm].s>0 && R_TB[elm].s!=itb )
                                              {
                                              #ifdef SPLIT_DEBUG    
                                                  cout<<"DUPLICATE iR2("<<R_TB[elm].s<<","<<itb<<"-"<<elm<<")";
                                              #endif
                                                  for (it_e2=uua.R.begin();it_e2!=uua.R.end();it_e2++)
                                                  {
                                                      if (R_TB[*it_e2].f==itb) R_TB[*it_e2].f = 0;
                                                      if (R_TB[*it_e2].s==itb) R_TB[*it_e2].s = 0;
                                                  }
                                                  for (it_e2=uua.E.begin();it_e2!=uua.E.end();it_e2++)
                                                      if (E_TB[*it_e2]==itb) E_TB[*it_e2] = 0;                                              
                                                  TBnum_used.erase(itb);
                                                  S_TB[itb]=0;
                                                  itb=R_TB[elm].s;
                                                  goto restartsearch1;
                                              }
                                              R_TB[elm].f=itb;                                            
                                              R_TB[elm].s=itb;                                           
                                          }
                                      }
                                  #ifdef SPLIT_DEBUG    
                                      cout<<*rit_seq<<"-"<<elm<<",";
                                  #endif
                                  }
                              if(S_TB[itb]<slength) S_TB[itb]=slength;
                          #ifdef SPLIT_DEBUG    
                              cout<<"} ";
                          #endif
                          }
                  }
                if(uua.OUTP.count(*it_p))  // output port
                  if (R_TB[*it_r].s==0)
                  {
                      canerase=false;
                      if(otb==0)
                      {
                        canerase=true;
                        otb=getTBnum(TBnum_used);
                      }
                  #ifdef SPLIT_DEBUG    
                      cout<<"out-"<<*it_p<<" ";
                  #endif
                      if (isconnected2PO(*it_p))
                      {
                          if(canerase) {
                              for (it_e2=uua.E.begin();it_e2!=uua.E.end();it_e2++)
                                  if (E_TB[*it_e2]==otb) E_TB[*it_e2] = -1;
                              for (it_e2=uua.R.begin();it_e2!=uua.R.end();it_e2++)
                              {
                                  if (R_TB[*it_e2].f==otb) R_TB[*it_e2].f = -1;
                                  if (R_TB[*it_e2].s==otb) R_TB[*it_e2].s = -1;
                              }
                              TBnum_used.erase(otb);
                              S_TB[otb]=0;
//                              otb=0;
                          }
                          otb=-1;
//                          R_TB[*it_r].s=-1/*unsigned(-1)*/;
//                          continue;
                      }
restartsearch2:
                      R_TB[*it_r].s=otb;
                      for (it_ro=uua.RO.begin();it_ro!=uua.RO.end();it_ro++)
                          if(it_ro->first.f==*it_p) // start in our port?
                          {
                          #ifdef SPLIT_DEBUG    
                              cout<<"('"<<*it_p<<"',"<<it_ro->first.s<<"){";
                          #endif
                              slength=0;
                              for (it_seq=it_ro->second.begin();it_seq!=it_ro->second.end();it_seq++)
                                  if(*it_p!=*it_seq)
                                  { 
                                      elm=port2element(*it_seq);
                                      if(elm==0) { 
                                      #ifdef SPLIT_DEBUG    
                                          cout<<*it_seq<<"-not element";
                                      #endif
                                          continue;
                                      }
                                      if(!isregister(elm)) {
                                          if(E_TB[elm]>0 && E_TB[elm]!=otb )
                                          {
                                          #ifdef SPLIT_DEBUG    
                                              cout<<"DUPLICATE E("<<E_TB[elm]<<","<<otb<<"-"<<elm<<")";
                                          #endif
                                              for (it_e2=uua.E.begin();it_e2!=uua.E.end();it_e2++)
                                                  if (E_TB[*it_e2]==otb) E_TB[*it_e2] = 0;                                              
                                              for (it_e2=uua.R.begin();it_e2!=uua.R.end();it_e2++)
                                              {
                                                  if (R_TB[*it_e2].f==otb) R_TB[*it_e2].f = 0;
                                                  if (R_TB[*it_e2].s==otb) R_TB[*it_e2].s = 0;
                                              }
                                              TBnum_used.erase(otb);
                                              S_TB[otb]=0;
                                              otb=E_TB[elm];
                                              goto restartsearch2;
                                          }
                                          E_TB[elm]=otb;
                                      } else {
                                          slength++;   
                                          if(v[regposnum(elm)])
                                          {
                                              if(R_TB[elm].f>0 && R_TB[elm].f!=otb ) 
                                              {
                                              #ifdef SPLIT_DEBUG    
                                                  cout<<"DUPLICATE R("<<R_TB[elm].f<<","<<otb<<"-"<<elm<<")";
                                              #endif
                                                  for (it_e2=uua.E.begin();it_e2!=uua.E.end();it_e2++)
                                                      if (E_TB[*it_e2]==otb) E_TB[*it_e2] = 0;                                              
                                                  for (it_e2=uua.R.begin();it_e2!=uua.R.end();it_e2++)
                                                  {
                                                      if (R_TB[*it_e2].f==otb) R_TB[*it_e2].f = 0;
                                                      if (R_TB[*it_e2].s==otb) R_TB[*it_e2].s = 0;
                                                  }
                                                  TBnum_used.erase(otb);
                                                  S_TB[otb]=0;
                                                  otb=R_TB[elm].f;
                                                  goto restartsearch2;
                                              }
                                              R_TB[elm].f=otb;
                                              break;                                             
                                          } else {
                                              if(R_TB[elm].f>0 && R_TB[elm].f!=otb ) 
                                              {
                                              #ifdef SPLIT_DEBUG    
                                                  cout<<"DUPLICATE R1("<<R_TB[elm].f<<","<<otb<<"-"<<elm<<")";
                                              #endif
                                                  for (it_e2=uua.E.begin();it_e2!=uua.E.end();it_e2++)
                                                      if (E_TB[*it_e2]==otb) E_TB[*it_e2] = 0;                                              
                                                  for (it_e2=uua.R.begin();it_e2!=uua.R.end();it_e2++)
                                                  {
                                                      if (R_TB[*it_e2].f==otb) R_TB[*it_e2].f = 0;
                                                      if (R_TB[*it_e2].s==otb) R_TB[*it_e2].s = 0;
                                                  }
                                                  TBnum_used.erase(otb);
                                                  S_TB[otb]=0;
                                                  otb=R_TB[elm].f;
                                                  goto restartsearch2;
                                              }
                                              if(R_TB[elm].s>0 && R_TB[elm].s!=otb )
                                              {
                                              #ifdef SPLIT_DEBUG    
                                                  cout<<"DUPLICATE R2("<<R_TB[elm].s<<","<<otb<<"-"<<elm<<")";
                                              #endif
                                                  for (it_e2=uua.E.begin();it_e2!=uua.E.end();it_e2++)
                                                      if (E_TB[*it_e2]==otb) E_TB[*it_e2] = 0;                                              
                                                  for (it_e2=uua.R.begin();it_e2!=uua.R.end();it_e2++)
                                                  {
                                                      if (R_TB[*it_e2].f==otb) R_TB[*it_e2].f = 0;
                                                      if (R_TB[*it_e2].s==otb) R_TB[*it_e2].s = 0;
                                                  }
                                                  TBnum_used.erase(otb);
                                                  S_TB[otb]=0;
                                                  otb=R_TB[elm].s;
                                                  goto restartsearch2;
                                              }
                                              R_TB[elm].f=otb;                                             
                                              R_TB[elm].s=otb;                                             
                                          }
                                      }
                                  #ifdef SPLIT_DEBUG    
                                      cout<<*it_seq<<"-"<<elm<<",";
                                  #endif
                                  }
                              if(S_TB[otb]<slength) S_TB[otb]=slength;
                          #ifdef SPLIT_DEBUG    
                              cout<<"} ";
                          #endif
                          }
                  }
            }
        #ifdef SPLIT_DEBUG    
            cout<<endl;
        #endif
        }        
        r++;
    }
    r=1;
    aS_TB.clear();
#ifdef SPLIT_DEBUG
    cout<<endl<<"tb(";
#endif
    for(it_TBnum_used=TBnum_used.begin();it_TBnum_used!=TBnum_used.end();it_TBnum_used++)
    {
      for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
        if (!isregister(*it_e)) {
          if(E_TB[*it_e]==(*it_TBnum_used))E_TB[*it_e]=r;
        } else {
          if(R_TB[*it_e].f==(*it_TBnum_used))R_TB[*it_e].f=r;
          if(R_TB[*it_e].s==(*it_TBnum_used))R_TB[*it_e].s=r;
        }
      aS_TB[r]=S_TB[*it_TBnum_used];
#ifdef SPLIT_DEBUG
      cout<<*it_TBnum_used<<",";
#endif
      r++;
    }
#ifdef SPLIT_DEBUG
    cout<<")"<<endl;
#endif
#ifdef SPLIT_DEBUG
    cout<<"R_TB>";
    for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
        cout<<"("<<*it_r<<";"<<R_TB[*it_r].f<<","<<R_TB[*it_r].s<<")";
    cout<<endl;
    cout<<"E_TB>";
    for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
        if (!isregister(*it_e))
            cout<<"("<<*it_e<<","<<E_TB[*it_e]<<")";
    cout<<endl;
#endif                  
    
//  return TBnum_used.size();    
    return (r-1);
}

unsigned scanregcount(tR_TB &R_TB)
{
    tR_TB::iterator it_R_TB;
    unsigned count=0;
    
    for (it_R_TB=R_TB.begin();it_R_TB!=R_TB.end();it_R_TB++)
    {
        if((it_R_TB->second.f!=it_R_TB->second.s) && (it_R_TB->second.f!=-1 /*INT_MAX unsigned(-1)*/) && (it_R_TB->second.s!=-1 /*INT_MAX unsigned(-1)*/)) count++;
    }   
    return count;
}
     
tfitness compute_fitness(bit_vector& v)
{
//    unsigned i;
    bit_vector::iterator it_bit_vector;
    telset::iterator it_e;
    tfitness f;
    double f1,f2,f3,f4,f5,f6;
    double dpom, dpom3, maxpom;
    unsigned pom;
    tR_TB R_TB;  // Map between register and TB on input and tb on output (0=not assigned)
    tE_TB E_TB;  // Map between element and TB (0=not assigned)
    tS_TB S_TB;  // Synchronistion pulse number of each TB
    map<tid,unsigned int> N_TB; // Number of internal elements of each TB
    unsigned z;
    tid x,y,tb;

    tb=compute_TB_split(v,R_TB,E_TB,S_TB);

    for (x=1;x<=tb;x++) { // compute N_TB
      z=0;
      for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
      {
        if (!isregister(*it_e))
            if (E_TB[*it_e] == x) z++;
        else 
            if ((R_TB[*it_e].f == x) && (R_TB[*it_e].s == x)) z++;
      }
      N_TB[x]=z;
    }

    pom=0;
    for (it_e=uua.R.begin();it_e!=uua.R.end();it_e++)
    {
        if (R_TB[*it_e].f==-1) pom+=1;
          else if (R_TB[*it_e].f!=0) pom+=1;
        if (R_TB[*it_e].s==-1) pom+=1;
          else if (R_TB[*it_e].s!=0) pom+=1;
    }
    f1=(double)pom/(uua.R.size()*2.0); // reflect how much registers are part of TB
    
    pom=0;z=0;
    for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
        if (!isregister(*it_e))
        {
           if (E_TB[*it_e] != 0) pom+=1;
           z++;
        } else {
          if (R_TB[*it_e].f==R_TB[*it_e].s) {
            if((R_TB[*it_e].f!=0) && (R_TB[*it_e].s!=0)) pom+=1;
            z++;
          }
        }
    if(z==0) z=1;
    f2=(double)pom/z; // reflect how much elements and internal registers are part of TB
    
    pom=0;
    for (it_bit_vector=v.begin();it_bit_vector!=v.end();it_bit_vector++)
        if (!(*it_bit_vector)) pom+=1;
    f3=(double)pom/v.size(); // reflects the number of registers that is not includet into scan
    
    pom=0;
    for (x=1;x<=tb;x++)
    {
      if (N_TB[x]>0) pom+=1;
    }
    f4=0;
    if (tb!=0)
    f4=(double)pom/tb; // reflects the number the TBs that is not empty
    
    f5=0;
    if(tb>1) {
      dpom=0;maxpom=0;
      for (x=1;x<=tb;x++)
        for (y=1;y<=tb;y++)
        {
          if(x!=y)
          {
            dpom3=(double)S_TB[x]-(double)S_TB[y];
            if(dpom3<0) dpom3= -dpom3;
            if( dpom3 > maxpom) maxpom=dpom3;
            dpom+=dpom3;
          }
        }
      dpom=dpom/(tb*(tb-1));
      if(maxpom==0) f5=1;
        else f5=1-(dpom/uua.R.size()); // reflect average deviation of sychronization distance
#ifdef DEBUG
      cout<<"S_TB>";
      for (x=1;x<=tb;x++)
            cout<<"("<<x<<","<<S_TB[x]<<")";
      cout<<endl;
      cout<<" pr="<<dpom<<" max="<<maxpom<<" R.s="<<uua.R.size()<<" f5="<<f5<<endl;
#endif
    }
 
    f6=0;
    if(tb>1) {
      dpom=0;maxpom=0;
      for (x=1;x<=tb;x++)
        for (y=1;y<=tb;y++)
        {
          if(x!=y)
          {
            dpom3=(double)N_TB[x]-(double)N_TB[y];
            if(dpom3<0) dpom3= -dpom3;
            if( dpom3 > maxpom) maxpom=dpom3;
            dpom+=dpom3;
          }
        }
      dpom=dpom/(tb*(tb-1));
      if(maxpom==0) f6=1;
        else f6=1-(dpom/uua.E.size()); // reflect average deviation of TB size
#ifdef DEBUG
      cout<<"N_TB>";
      for (x=1;x<=tb;x++)
            cout<<"("<<x<<","<<N_TB[x]<<")";
      cout<<endl;            
      cout<<" pr="<<dpom<<" max="<<maxpom<<" E.s="<<uua.E.size()<<" f6="<<f6<<endl;
#endif
    }

    f=2*f1+3*f2/*+f3*/+5*f4+f5+2*f6;
//    f=1/(f3+0.00001);
    
#ifdef DEBUG
    cout<<"fit>2*"<<f1<<"+3*"<<f2<</*"+"<<f3<<*/"+5*"<<f4<<"+"<<f5<<"+2*"<<f6<<"="<<f<<" tb="<<tb<<endl;
#endif
//    f=f+tb;
//    f=f-tb;
    return f;
}

int is_it_tbx_node(tR_TB &R_TB, tE_TB &E_TB, int TB, tidsetmap::iterator &it_V)
{
     telset::iterator it_port;
     telset::iterator it_telset;
     tid element;
     int type=0;  //-1 not TBx node, 0 internal node, 1 input external node, 2 output external node
     int output=0;
     int found=0;

     for(it_port=it_V->second.begin();it_port!=it_V->second.end(); it_port++)
     {
         it_telset=uua.PO.find(*it_port);
         if (it_telset!=uua.PO.end()) {
           type=1;
           continue;
         }
         it_telset=uua.PI.find(*it_port);
         if (it_telset!=uua.PI.end())
         {
            type=1;
            continue;
         }
         element=port2element(*it_port);
         if (isregister(element)) {
           if (R_TB[element].f==R_TB[element].s){
             if (R_TB[element].f==TB) 
             {
               found=1;
               it_telset=uua.OUTP.find(*it_port);
               if (it_telset!=uua.OUTP.end()) {
                 output=1;
               }
             } else type=1;
           } else {
             type=1;
           }
         } else {
           if (E_TB[element]==TB) 
           {
             found=1;
             it_telset=uua.OUTP.find(*it_port);
             if (it_telset!=uua.OUTP.end()) {
               output=1;
             }
           } else type=1;           
         }
     }
     if (type!=0) type+=output;
     if (found==0) type=-1;
     return type;
}

tid GetNode(tid port)
{
    tidsetmap::iterator it_V;

    for(it_V=uua.V.begin();it_V!=uua.V.end(); it_V++)
    {
      if(it_V->second.find(port)!=it_V->second.end())
      {
        break;
      }
    }
    if(it_V!=uua.V.end()) return it_V->first;
    else return 0;
}

void putwirename(tid node, telset &ports, ofstream &outfile, telset &wires)
{
     telset::iterator it_port;
     bool nalezeno=false;

     for(it_port=ports.begin();it_port!=ports.end(); it_port++)
     {
       if (uua.PI.find(*it_port)!=uua.PI.end())
       {
           outfile<<uua.GN[*it_port];
           nalezeno=true;
           break;
       }
       if (uua.PO.find(*it_port)!=uua.PO.end())
       {
           outfile<<uua.GN[*it_port];
           nalezeno=true;
           break;
       }
     }
     if(!nalezeno) 
     {
       outfile<<"N"<<node;
       
       wires.insert(node);
     }
     return;
}

void WriteTBVerilog(tR_TB &R_TB, tE_TB &E_TB, unsigned NumOfTB, char *verilogfile)
{
    char filename[500];
    char buffer[500];
    unsigned i;
    ofstream outfile;
    tR_TB::iterator it_R_TB;
    tE_TB::iterator it_E_TB;
    telset::iterator it_telset;
    tidsetmap::iterator it_psi,it_con; 
    unsigned node_type;  // 0 internal node, 1 input external node, 2 output external node
    tidsetmap::iterator it_V;
    bool first;
    telset::iterator it_e;
    telset::iterator it_r;
    telset wires;
    telset::iterator it_wires;
    tid pomid;
    set<string> saved_modules;
    

    strcpy(filename,verilogfile);
    strcat(filename,".v");
    cout<<"*Save TB as verilog ("<<filename<<")..."<<endl;
    ofstream vf(filename);
    vf<<"// Verilog"<<endl<<"// created by TB"<<endl<<endl;
    strcpy(filename,verilogfile);
    strcat(filename,"_register.v");
    cout<<"*Subfile ("<<filename<<") "<<endl;
    outfile.open(filename);
/*    outfile<<"// Verilog definition of register"<<endl<<"// created by TB"<<endl<<endl;
    outfile<<endl<<"module dff (clock, q, data);"<<endl;
    outfile<<"  // port list"<<endl;
    outfile<<"  input   data, clock;"<<endl;
    outfile<<"  output  q;"<<endl;
    outfile<<"  // reg / wire declaration for outputs / inouts"<<endl;
    outfile<<"  reg     q;"<<endl;
    outfile<<"  // logic begins here"<<endl;
    outfile<<"  always @(posedge clock)"<<endl;
    outfile<<"    q <= data;"<<endl;
    outfile<<"endmodule"<<endl<<endl;*/
    outfile<<"// Used Modules"<<endl<<endl;
    for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
    {
       if ( saved_modules.count(uua.ELT[*it_e]) == 0)
       {
           outfile<<"module";
           outfile<<"  "<<uua.ELT[*it_e]<<" "<<"(";
           it_psi=uua.PSI.find(*it_e);
           first=true;
           for (it_telset=it_psi->second.begin();it_telset!=it_psi->second.end();it_telset++)
            {
              if (first)
              {
                outfile<<uua.GN[*it_telset];
                first=false;
              } else {
                outfile<<", "<<uua.GN[*it_telset];
              }
           }           
           outfile<<");"<<endl;
           for (it_telset=it_psi->second.begin();it_telset!=it_psi->second.end();it_telset++)
            {
             if((uua.INP.count(*it_telset)!=0) || (uua.CI.count(*it_telset)!=0))
             {
                outfile<<"input ";       
                if (uua.WIDTH[*it_telset]>1)
                  outfile<<"["<<uua.WIDTH[*it_telset]<<":0]";
                outfile<<uua.GN[*it_telset];
                outfile<<";"<<endl;       
             }
           }           
           for (it_telset=it_psi->second.begin();it_telset!=it_psi->second.end();it_telset++)
            {
             if(uua.OUTP.count(*it_telset)!=0)
             {
                outfile<<"output ";       
                if (uua.WIDTH[*it_telset]>1)
                  outfile<<"["<<uua.WIDTH[*it_telset]<<":0]";
                outfile<<uua.GN[*it_telset];
                outfile<<";"<<endl;
             }
           }           
           outfile<<endl;       
           outfile<<"endmodule"<<endl<<endl;
           saved_modules.insert(uua.ELT[*it_e]);
       }
    }
    outfile.close();
    vf<<"`include \""<<filename<<"\""<<endl;
    
    for(i=1;i<=NumOfTB;i++)
    {
      strcpy(filename,verilogfile);
      strcat(filename,"_");
      sprintf(buffer,"%d",i);
      strcat(filename,buffer);
//      strcat(filename,itoa(i,buffer,10));
      strcat(filename,".v");
      cout<<"*Subfile ("<<filename<<") "<<endl;
      vf<<"`include \""<<filename<<"\""<<endl;
      outfile.open(filename);
      outfile<<"// Verilog definition of TB"<<i<<endl<<"// created by TB"<<endl<<endl;
      outfile<<"module TB"<<i<<"(";
      cout<<"Scanning nodes for interface..."<<endl; 
      first=true; 
#ifdef VERILOG_DEBUG
          cout<<"Found node ";
#endif
      for(it_V=uua.V.begin();it_V!=uua.V.end(); it_V++)
      {
        node_type=is_it_tbx_node(R_TB, E_TB, i, it_V);
        if( (node_type==1) || (node_type==2)) {
#ifdef VERILOG_DEBUG
          cout<<"N"<<it_V->first<<", ";
#endif
          if (first)
          {
            outfile<<"N"<<it_V->first;
            first=false;
          } else {
            outfile<<", N"<<it_V->first;
          }
        }
      }
#ifdef VERILOG_DEBUG
      cout<<endl;
#endif
      outfile<<");"<<endl;
      cout<<"Scanning nodes for input..."<<endl; 
#ifdef VERILOG_DEBUG
          cout<<"Found node ";
#endif
      for(it_V=uua.V.begin();it_V!=uua.V.end(); it_V++)
      {
        node_type=is_it_tbx_node(R_TB, E_TB, i, it_V);
        if( node_type==1) {
#ifdef VERILOG_DEBUG
          cout<<"N"<<it_V->first<<", ";
#endif
          outfile<<"input ";
          if (uua.WIDTH[*(it_V->second.begin())]>1)
            outfile<<"["<<uua.WIDTH[*(it_V->second.begin())]<<":0]";
          outfile<<"N"<<it_V->first;
          outfile<<";"<<endl;
        }
      }
#ifdef VERILOG_DEBUG
      cout<<endl;
#endif
      cout<<"Scanning nodes for output..."<<endl; 
#ifdef VERILOG_DEBUG
          cout<<"Found node ";
#endif
      for(it_V=uua.V.begin();it_V!=uua.V.end(); it_V++)
      {
        node_type=is_it_tbx_node(R_TB, E_TB, i, it_V);
        if( node_type==2) {
#ifdef VERILOG_DEBUG
          cout<<"N"<<it_V->first<<", ";
#endif
          outfile<<"output ";
          if (uua.WIDTH[*(it_V->second.begin())]>1)
            outfile<<"["<<uua.WIDTH[*(it_V->second.begin())]<<":0]";
          outfile<<"N"<<it_V->first;
          outfile<<";"<<endl;
        }
      }
#ifdef VERILOG_DEBUG
      cout<<endl;
#endif
      outfile<<endl;
      cout<<"Scanning nodes for wires..."<<endl; 
#ifdef VERILOG_DEBUG
          cout<<"Found node ";
#endif
      for(it_V=uua.V.begin();it_V!=uua.V.end(); it_V++)
      {
        node_type=is_it_tbx_node(R_TB, E_TB, i, it_V);
        if( node_type==0) {
#ifdef VERILOG_DEBUG
          cout<<"N"<<it_V->first<<", ";
#endif
          outfile<<"  wire ";
          if (uua.WIDTH[*(it_V->second.begin())]>1)
            outfile<<"["<<uua.WIDTH[*(it_V->second.begin())]<<":0]";
          outfile<<"N"<<it_V->first;
          outfile<<";"<<endl;
        }
      }
#ifdef VERILOG_DEBUG
      cout<<endl;
#endif
      outfile<<endl;
#ifdef VERILOG_DEBUG
          cout<<"Element ";
#endif
      for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
      {
          if(R_TB[*it_r].f==R_TB[*it_r].s)
            if (R_TB[*it_r].f==(tid)i)
            {
#ifdef VERILOG_DEBUG
              cout<<uua.ELN[*it_r]<<", ";
#endif
              outfile<<"  "<<uua.ELT[*it_r]<<" "<<uua.ELN[*it_r]<<"(";
              it_psi=uua.PSI.find(*it_r);
              first=true;
              for (it_telset=it_psi->second.begin();it_telset!=it_psi->second.end();it_telset++)
              {
                if (first)
                {
                  outfile<<"N"<<GetNode(*it_telset);
                  first=false;
                } else {
                  outfile<<", N"<<GetNode(*it_telset);
                }
              }
              outfile<<");"<<endl;
            }
      }
      for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
      {
          if (E_TB[*it_e]==(tid)i)
          {
#ifdef VERILOG_DEBUG
             cout<<uua.ELN[*it_e]<<", ";
#endif
             outfile<<"  "<<uua.ELT[*it_e]<<" "<<uua.ELN[*it_e]<<"(";
             it_psi=uua.PSI.find(*it_e);
             first=true;
             for (it_telset=it_psi->second.begin();it_telset!=it_psi->second.end();it_telset++)
             {
               if (first)
               {
                 outfile<<"N"<<GetNode(*it_telset);
                 first=false;
               } else {
                 outfile<<", N"<<GetNode(*it_telset);
               }
             }
             outfile<<");"<<endl;
          }
      }
#ifdef VERILOG_DEBUG
      cout<<endl;
#endif
      outfile<<endl<<"endmodule"<<endl;
      
      outfile.close();
    }
    cout<<"*Computing main file..."<<endl;    
    vf<<endl<<"module "<<uua.name<<"(";
    for(it_telset=uua.PI.begin();it_telset!=uua.PI.end(); )
    {
       vf<<uua.GN[*it_telset];
       it_telset++;
       if (it_telset!=uua.PI.end()) vf<<", ";
    }
    if (uua.PO.begin()!=uua.PO.end()) vf<<", ";
    for(it_telset=uua.PO.begin();it_telset!=uua.PO.end(); )
    {
       vf<<uua.GN[*it_telset];
       it_telset++;
       if (it_telset!=uua.PO.end()) vf<<", ";
    }
    vf<<");"<<endl;
    for(it_telset=uua.PI.begin();it_telset!=uua.PI.end(); )
    {
       vf<<"input ";
       if (uua.WIDTH[*it_telset]>1)
         vf<<"["<<uua.WIDTH[*it_telset]<<":0]"<<uua.GN[*it_telset];       
       else
         vf<<uua.GN[*it_telset];
       it_telset++;
       vf<<";"<<endl;
    }
    for(it_telset=uua.PO.begin();it_telset!=uua.PO.end(); )
    {
       vf<<"output ";
       if (uua.WIDTH[*it_telset]>1)
         vf<<"["<<uua.WIDTH[*it_telset]<<":0]"<<uua.GN[*it_telset];       
       else
         vf<<uua.GN[*it_telset];
       it_telset++;
      vf<<";"<<endl;
    }
    vf<<endl;
    for(i=1;i<=NumOfTB;i++)
    {
      vf<<"  TB"<<i<<" iTB"<<i<<"(";
      first=true; 
      for(it_V=uua.V.begin();it_V!=uua.V.end(); it_V++)
      {
        node_type=is_it_tbx_node(R_TB, E_TB, i, it_V);
        if( (node_type==1) || (node_type==2)) {
          if (first)
          {
            putwirename(it_V->first,it_V->second,vf,wires);
            first=false;
          } else {
            vf<<", ";
            putwirename(it_V->first,it_V->second,vf,wires);
          }
        }
      }
      vf<<");"<<endl;
    }

#ifdef VERILOG_DEBUG
          cout<<"Element ";
#endif
      for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
      {
          if (!isregister(*it_e)) if (E_TB[*it_e]<=0)
          {
#ifdef VERILOG_DEBUG
             cout<<uua.ELN[*it_e]<<"-"<<*it_e<<", ";
#endif
             vf<<"  "<<uua.ELT[*it_e]<<" "<<uua.ELN[*it_e]<<"(";
             it_psi=uua.PSI.find(*it_e);
             first=true;
             for (it_telset=it_psi->second.begin();it_telset!=it_psi->second.end();it_telset++)
             {
               pomid=GetNode(*it_telset);
               if (first)
               {
                 putwirename(pomid,uua.V[pomid],vf,wires);
                 first=false;
               } else {
                 vf<<", ";
                 putwirename(pomid,uua.V[pomid],vf,wires);
               }
             }
             vf<<");"<<endl;
          }
      }
      for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
      {
          if(R_TB[*it_r].f==R_TB[*it_r].s)
          {
            if (R_TB[*it_r].f<=0)
            {
#ifdef VERILOG_DEBUG
              cout<<uua.ELN[*it_r]<<", ";
#endif
              vf<<"  "<<uua.ELT[*it_r]<<" "<<uua.ELN[*it_r]<<"(";
              it_psi=uua.PSI.find(*it_r);
              first=true;
              for (it_telset=it_psi->second.begin();it_telset!=it_psi->second.end();it_telset++)
              {
                pomid=GetNode(*it_telset);
                if (first)
                {
                  putwirename(pomid,uua.V[pomid],vf,wires);
                  first=false;
                } else {
                  vf<<", ";
                  putwirename(pomid,uua.V[pomid],vf,wires);
                }
              }
              vf<<");"<<endl;
            } 
           } else {
#ifdef VERILOG_DEBUG
              cout<<uua.ELN[*it_r]<<", ";
#endif
              vf<<"  "<<uua.ELT[*it_r]<<" "<<uua.ELN[*it_r]<<"(";
              it_psi=uua.PSI.find(*it_r);
              first=true;
              for (it_telset=it_psi->second.begin();it_telset!=it_psi->second.end();it_telset++)
              {
                pomid=GetNode(*it_telset);
                if (first)
                {
                  putwirename(pomid,uua.V[pomid],vf,wires);
                  first=false;
                } else {
                  vf<<", ";
                  putwirename(pomid,uua.V[pomid],vf,wires);
                }
              }
              vf<<");";
              vf<<" // TB"<<R_TB[*it_r].f<<", TB"<<R_TB[*it_r].s<<endl;
            }
      }
#ifdef VERILOG_DEBUG
      cout<<endl;
#endif
    vf<<endl;
    for(it_wires=wires.begin();it_wires!=wires.end();it_wires++)
    {
        vf<<"  wire ";
        if (uua.WIDTH[*(uua.V[*it_wires].begin())]>1)
          vf<<"["<<uua.WIDTH[*(uua.V[*it_wires].begin())]<<":0]";
        vf<<"N"<<*it_wires;
        vf<<";"<<endl;
    }
    vf<<endl<<"endmodule"<<endl;
    vf.close();
    cout<<"*Saved!"<<endl;
}

bool DeleteLoopbrakRegisters(tR_TB &R_TB, tE_TB &E_TB)
{
    telset::iterator it_r;
    bool stdeleted=false;
    telset::iterator it_set;
    tid port1,port2,port3,pomnode1,pomnode2;
    tpairset::iterator it_IC;
    tpairset::iterator it_C2;
    tpairset ICcopy;
    telset Rcopy;
    tdelta::iterator it_DELTA;
    tdelta DELTAcopy;
    tro::iterator it_RO,it_RO2;
    tsequence seq;
    tsequence::iterator it_seq;
    bool rofound;

    Rcopy.insert(uua.R.begin(),uua.R.end());
    for(it_r=Rcopy.begin();it_r!=Rcopy.end();it_r++)
      if((strcmp(uua.ELT[*it_r].c_str(),"xdff")==0) && (R_TB[*it_r].f==R_TB[*it_r].s))
      {
        stdeleted=true;
        cout<<uua.ELN[*it_r];
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<" E("<<*it_r<<")";
#endif
        uua.E.erase(*it_r);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"R("<<*it_r<<")";
#endif
        uua.R.erase(*it_r);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"ELN("<<*it_r<<","<<uua.ELN[*it_r]<<")";
#endif
        uua.ELN.erase(*it_r);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"ELT("<<*it_r<<","<<uua.ELT[*it_r]<<")";
#endif
        uua.ELT.erase(*it_r);
        it_set=uua.PSI[*it_r].begin();
        port1=*it_set;
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"INP("<<*it_set<<")";
#endif
        uua.INP.erase(*it_set);
        it_set++;
        port2=*it_set;
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"OUTP("<<*it_set<<")";
#endif
        uua.OUTP.erase(*it_set);
        it_set++;
        port3=*it_set;
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"CI("<<*it_set<<")";
#endif
        uua.CI.erase(*it_set);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"MI("<<port1<<","<<port2<<")";
#endif
        uua.MI.erase(tpair(port1,port2));
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"GN("<<port1<<","<<uua.GN[port1]<<")";
#endif
        uua.GN.erase(port1);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"GN("<<port2<<","<<uua.GN[port2]<<")";
#endif
        uua.GN.erase(port2);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"GN("<<port3<<","<<uua.GN[port3]<<")";
#endif
        uua.GN.erase(port3);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"WIDTH("<<port1<<","<<uua.WIDTH[port1]<<")";
#endif
        uua.WIDTH.erase(port1);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"WIDTH("<<port2<<","<<uua.WIDTH[port2]<<")";
#endif
        uua.WIDTH.erase(port2);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"WIDTH("<<port3<<","<<uua.WIDTH[port3]<<")";
#endif
        uua.WIDTH.erase(port3);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"PSI("<<*it_r<<"-"<<port1<<","<<port2<<","<<port3<<")";
#endif
        uua.PSI.erase(*it_r);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"P("<<port1<<")";
#endif
        uua.P.erase(port1);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"P("<<port2<<")";
#endif
        uua.P.erase(port2);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"P("<<port3<<")";
#endif
        uua.P.erase(port3);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"M("<<port1<<","<<port2<<")";
#endif
        uua.M.erase(tpair(port1,port2));
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"C("<<port1<<","<<port1<<")";
#endif
        uua.C.erase(tpair(port1,port1));
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"C("<<port2<<","<<port2<<")";
#endif
        uua.C.erase(tpair(port2,port2));
        ICcopy.clear();
        ICcopy.insert(uua.C.begin(),uua.C.end());
        for (it_C2=ICcopy.begin();it_C2!=ICcopy.end();it_C2++)
          for (it_IC=ICcopy.begin();it_IC!=ICcopy.end();it_IC++)
          {
            if( ((it_C2->f==port1) && (it_IC->s==port2)) || ((it_C2->f==port2) && (it_IC->s==port1)) )
            {
#ifdef DEBUG_LOOPBREAKREMOVE
              cout<<"C("<<it_C2->f<<","<<it_C2->s<<")";
#endif
              uua.C.erase(*it_C2);
#ifdef DEBUG_LOOPBREAKREMOVE
              cout<<"C+("<<it_IC->f<<","<<it_C2->s<<")";
#endif
              uua.C.insert(tpair(it_IC->f,it_C2->s));
            }
            if( ((it_C2->s==port1) && (it_IC->f==port2)) || ((it_C2->s==port2) && (it_IC->f==port1)) )
            {
#ifdef DEBUG_LOOPBREAKREMOVE
              cout<<"C("<<it_C2->f<<","<<it_C2->s<<")";
#endif
              uua.C.erase(*it_C2);
#ifdef DEBUG_LOOPBREAKREMOVE
              cout<<"C+("<<it_C2->f<<","<<it_IC->s<<")";
#endif
              uua.C.insert(tpair(it_C2->f,it_IC->s));
            }
          }
        ICcopy.clear();
        ICcopy.insert(uua.I.begin(),uua.I.end());
        for (it_IC = ICcopy.begin();it_IC != ICcopy.end();it_IC++)
        {
            if((it_IC->f==port1) || (it_IC->f==port2) || (it_IC->s==port1) || (it_IC->s==port2)) {
#ifdef DEBUG_LOOPBREAKREMOVE
              cout<<"I("<<it_IC->f<<","<<it_IC->s<<")";
#endif
              uua.I.erase(*it_IC);
            }
        }
        ICcopy.clear();
        ICcopy.insert(uua.II.begin(),uua.II.end());
        for (it_IC = ICcopy.begin();it_IC != ICcopy.end();it_IC++)
        {
            if((it_IC->f==port1) || (it_IC->f==port2) || (it_IC->s==port1) || (it_IC->s==port2)) {
#ifdef DEBUG_LOOPBREAKREMOVE
              cout<<"II("<<it_IC->f<<","<<it_IC->s<<")";
#endif
              uua.II.erase(*it_IC);
            }
        }
        pomnode1=GetNode(port1);
        pomnode2=GetNode(port2);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"V("<<pomnode1<<"+"<<pomnode2<<")";
#endif
        uua.V[pomnode1].erase(port1);
        uua.V[pomnode2].erase(port2);
        uua.V[pomnode1].insert(uua.V[pomnode2].begin(),uua.V[pomnode2].end());
        uua.V.erase(pomnode2);
        pomnode1=GetNode(port3);
        uua.V[pomnode1].erase(port3);
#ifdef DEBUG_LOOPBREAKREMOVE
        cout<<"V-clk("<<pomnode1<<")";
#endif
        ICcopy.clear();
        ICcopy.insert(uua.C.begin(),uua.C.end());
        for (it_IC=ICcopy.begin();it_IC!=ICcopy.end();it_IC++)
        {
            if( (it_IC->f==port3) || (it_IC->s==port3) )
            {
#ifdef DEBUG_LOOPBREAKREMOVE
                cout<<"C-clk("<<it_IC->f<<","<<it_IC->s<<")";
#endif
                uua.C.erase(*it_IC);
            }
        }        
        ICcopy.clear();
        DELTAcopy.insert(uua.DELTA.begin(),uua.DELTA.end());
        for (it_DELTA=DELTAcopy.begin();it_DELTA!=DELTAcopy.end();it_DELTA++)
        {
            if( (it_DELTA->first.f==port1) || (it_DELTA->first.s==port1) || (it_DELTA->first.f==port2) || (it_DELTA->first.s==port2))
            {
#ifdef DEBUG_LOOPBREAKREMOVE
                cout<<"DELTA("<<it_DELTA->first.f<<","<<it_DELTA->first.s<<")";
#endif
                uua.DELTA.erase(it_DELTA->first);
            }            
        }
        DELTAcopy.clear();
        for (it_RO=uua.RO.begin();it_RO!=uua.RO.end();it_RO++)
        {
            seq.clear();
            rofound=false;
            for(it_seq=it_RO->second.begin();it_seq!=it_RO->second.end();it_seq++)
            {
              if( (*it_seq!=port1) && (*it_seq!=port2) )
              {
                seq.push_back(*it_seq);
              } else rofound=true;

            }
            if(rofound) {
#ifdef DEBUG_LOOPBREAKREMOVE
                cout<<"RO("<<it_RO->first.f<<","<<it_RO->first.s<<"-"<<port1<<")";
#endif
                it_RO->second=seq;
            }
            if( (it_RO->first.f==port1) || (it_RO->first.s==port1) || (it_RO->first.f==port2) || (it_RO->first.s==port2))
            {
#ifdef DEBUG_LOOPBREAKREMOVE
                cout<<"RO("<<it_RO->first.f<<","<<it_RO->first.s<<")";
#endif
                if(it_RO==uua.RO.begin())
                {
                  uua.RO.erase(it_RO);
                  it_RO==uua.RO.begin();
                } else {
                  it_RO2=it_RO;
                  it_RO--;
                  uua.RO.erase(it_RO2);
                }
            }
        }
        cout<<",";
      }
    if (stdeleted) cout<<"registers removed."<<endl;
    return stdeleted;
}

int find_tb(char *nunit)
{
    terr e;
    telset::iterator it_e;
    telset::iterator it_p;
    tpairset::iterator it_C;
    unsigned reg_count;
    unsigned i,ii;
    tR_TB R_TB;  // Map between register and TB on input and tb on output (0=not assigned)
    tE_TB E_TB;  // Map between element and TB (0=not assigned)
    tS_TB S_TB;  // Synchronistion pulse number
    unsigned population_size=default_population_size;
    char *poms;
    char filename[500];
    tgnames::iterator it_elt;
    
    cout<<"Loading unit ("<<nunit<<")...";
    e=uua.LoadFormalUUA(nunit);
    if (e!=e_ok) {
        cout<<GetErrStr(e)<<endl<<endl;
        return 2;
    }
    cout<<"Done"<<endl;

/*    cout<<"Generating EG, PG, CG for unit...";
    for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
         if (uua.EG.count((*it_e))==0)
            uua.EG.insert(tgnames::value_type((*it_e),nunit));

    for (it_p=uua.P.begin();it_p!=uua.P.end();it_p++)
         if (uua.PG.count((*it_p))==0)
            uua.PG.insert(tgnames::value_type((*it_p),nunit));
    for (it_p=uua.PI.begin();it_p!=uua.PI.end();it_p++)
         if (uua.PG.count((*it_p))==0)
            uua.PG.insert(tgnames::value_type((*it_p),nunit));
    for (it_p=uua.PO.begin();it_p!=uua.PO.end();it_p++)
         if (uua.PG.count((*it_p))==0)
            uua.PG.insert(tgnames::value_type((*it_p),nunit));

    for (it_C=uua.C.begin();it_C!=uua.C.end();it_C++)
         if (uua.CG.count((*it_C))==0)
            uua.CG.insert(tpairstrmap::value_type((*it_C),nunit));
    cout<<"Done"<<endl;*/

    cout<<"Preparing registers";
    reg_count = uua.R.size();
    cout<<"("<<reg_count<<")...";
    
#ifdef DEBUG    
    cout<<endl<<"R> ";
    for (it_e=uua.R.begin();it_e!=uua.R.end();it_e++)
      cout<<*it_e<<" ";
    cout<<endl;
#endif
    cout<<"Done"<<endl;

/****************** Variables *******************/    
    set<tchromosom> population, new_population;
    bit_vector v, o1, o2;
    set<tchromosom>::iterator it_population, parent1, parent2;
    bit_vector::iterator it_bit_vector;
    unsigned newpopcount;
    unsigned long generation=0;
    telset::iterator it_r;
    unsigned NumOfTB,x;
    bool loopbreakfound;
/***********************************************/    
    
    cout<<"Init population...";
    population.clear();
    if(population_size>reg_count)
      if (population_size>(unsigned)(1<<reg_count))
          population_size=(unsigned)(1<<reg_count);
    v.clear();

    for(ii=1;ii<=reg_count;ii++)
        v.insert(v.end(),1);
    population.insert(population.end(),tchromosom(v,compute_fitness(v)));

    for(i=2;population.size()<population_size;i++)
    {
        v.clear();
        for(ii=1;ii<=reg_count;ii++)
            v.insert(v.end(),rand()%2);
        population.insert(population.end(),tchromosom(v,compute_fitness(v)));
    }
    generation++;
    cout<<"Done"<<endl;
    cout<<"Computing..."<<endl;
    while (generation<=10) {
#ifdef DEBUG    
        cout<<"population>"<<endl;
        for (it_population=population.begin();it_population!=population.end();it_population++)
        {
            cout<<it_population->s<<": ";
            v=it_population->f;
            for (it_bit_vector=v.begin();it_bit_vector!=v.end();it_bit_vector++)
                cout<<*it_bit_vector;
            cout<<endl;
        }
#endif
        new_population.clear();
        for(newpopcount=0;new_population.size()<new_p_size && newpopcount<(new_p_size/2+1);newpopcount++)
        {
            roulette(population, parent1, parent2);
            if ((rand()%101)<=crossover_probability)
               crossover(parent1, parent2, o1, o2, reg_count);
            else {
                o1=parent1->f;
                o2=parent2->f;
            }
        #ifdef DEBUG    
             cout<<"child1>";
                for (it_bit_vector=o1.begin();it_bit_vector!=o1.end();it_bit_vector++)
                    cout<<*it_bit_vector;
                cout<<endl;
             cout<<"child2>";
                for (it_bit_vector=o2.begin();it_bit_vector!=o2.end();it_bit_vector++)
                    cout<<*it_bit_vector;
                cout<<endl;
        #endif
            if ((rand()%101)<=mutation_probability)
            {
               mutation(o1, reg_count);
               mutation(o2, reg_count);
        #ifdef DEBUG    
               cout<<"child1 after mutation>";
               for (it_bit_vector=o1.begin();it_bit_vector!=o1.end();it_bit_vector++)
                   cout<<*it_bit_vector;
               cout<<endl;
               cout<<"child2 after mutation>";
               for (it_bit_vector=o2.begin();it_bit_vector!=o2.end();it_bit_vector++)
                   cout<<*it_bit_vector;
               cout<<endl;
        #endif
            }
            new_population.insert(new_population.end(),tchromosom(o1,compute_fitness(o1)));
            new_population.insert(new_population.end(),tchromosom(o2,compute_fitness(o2)));
        #ifdef DEBUG    
             cout<<"status> size/plan-iteration "<<new_population.size()<<"/"<<new_p_size<<"-"<<newpopcount<<" generation>"<<generation<<endl;
        #endif
        }
    #ifdef DEBUG    
        cout<<"new population>"<<endl;
        for (it_population=new_population.begin();it_population!=new_population.end();it_population++)
        {
            cout<<it_population->s<<": ";
            v=it_population->f;
            for (it_bit_vector=v.begin();it_bit_vector!=v.end();it_bit_vector++)
                cout<<*it_bit_vector;
            cout<<endl;
        }
    #endif
        // erase worst chromosome (set is sorted by fitness)
        while (population.size()>(population_size-new_p_size))
              population.erase(population.begin());
        for (it_population=new_population.begin();it_population!=new_population.end();it_population++)
            population.insert(population.end(),*it_population);
        
        generation++;
        cout<<"generation>"<<generation<<"\r";
    #ifdef DEBUG    
        cout<<endl;
    #endif
    }
    it_population=population.end();
    it_population--;
    cout<<"Done"<<endl;
    cout<<"Best "<<it_population->s<<":";
    v=it_population->f;
    for (it_bit_vector=v.begin();it_bit_vector!=v.end();it_bit_vector++)
        cout<<*it_bit_vector;
    cout<<endl;
    NumOfTB=compute_TB_split(v, R_TB, E_TB, S_TB);
    cout<<"Number of TBs>"<<NumOfTB<<endl;
    cout<<"R_TB>";
    tid r=0;
    for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
    {
        if ((R_TB[*it_r].f==R_TB[*it_r].s)&&(v[r]))
          cout<<" ->";
        cout<<"("<<*it_r<<";"<<R_TB[*it_r].f<<","<<R_TB[*it_r].s<<")";
        r++;
    }
    cout<<endl;
    cout<<"E_TB>";
    for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
        if (!isregister(*it_e))
            cout<<"("<<*it_e<<","<<E_TB[*it_e]<<")";
    cout<<endl;
    cout<<"S_TB>";
    for (x=1;x<=NumOfTB;x++)
            cout<<"("<<x<<","<<S_TB[x]<<")";
    cout<<endl;
    cout<<"Number of REGs in SCAN>"<<scanregcount(R_TB)<<endl;
    cout<<endl;
    poms=strstr(nunit,".");
    if(poms) *poms=0;
    strcpy(filename,nunit);
    strcat(filename,".tb");
    ofstream tbsave (filename);
    tbsave<<"R_TB>";
    for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
        tbsave<<"("<<*it_r<<";"<<R_TB[*it_r].f<<","<<R_TB[*it_r].s<<")";
    tbsave<<endl;
    tbsave<<"E_TB>";
    for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
        if (!isregister(*it_e))
            tbsave<<"("<<*it_e<<","<<E_TB[*it_e]<<")";
    tbsave<<endl;
    tbsave<<"S_TB>";
    for (x=1;x<=NumOfTB;x++)
            tbsave<<"("<<x<<","<<S_TB[x]<<")";
    tbsave<<endl;
    tbsave.close();
    WriteTBVerilog(R_TB, E_TB, NumOfTB, nunit);
    loopbreakfound=false;
    for(it_elt=uua.ELT.begin();it_elt!=uua.ELT.end();it_elt++)
    {
      if(it_elt->second.compare("xdff")==0) loopbreakfound=true;
    }
    if (loopbreakfound) {
      cout<<endl;
      cout<<"Loopbreak used, finding and deleting unused loopbreak registers..."<<endl;
      if(DeleteLoopbrakRegisters(R_TB, E_TB))
      {
          cout<<"R_TB>";
          for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
              cout<<"("<<*it_r<<";"<<R_TB[*it_r].f<<","<<R_TB[*it_r].s<<")";
          cout<<endl;
          cout<<"E_TB>";
          for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
              if (!isregister(*it_e))
                  cout<<"("<<*it_e<<","<<E_TB[*it_e]<<")";
          cout<<endl;
          cout<<"Number of REGs in SCAN>"<<scanregcount(R_TB)<<endl;
          cout<<endl;
          poms=strstr(nunit,".");
          if(poms) *poms=0;
          strcpy(filename,nunit);
          strcat(filename,"_x.tb");
          ofstream tbsave (filename);
          tbsave<<"R_TB>";
          for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
              tbsave<<"("<<*it_r<<";"<<R_TB[*it_r].f<<","<<R_TB[*it_r].s<<")";
          tbsave<<endl;
          tbsave<<"E_TB>";
          for (it_e=uua.E.begin();it_e!=uua.E.end();it_e++)
              if (!isregister(*it_e))
                  tbsave<<"("<<*it_e<<","<<E_TB[*it_e]<<")";
          tbsave<<endl;
          tbsave.close();
            
          poms=strstr(nunit,".");
          if(poms) *poms=0;
          strcpy(filename,nunit);
          strcat(filename,"_x");
          WriteTBVerilog(R_TB, E_TB, NumOfTB, filename);
          strcat(filename,".ruz");
          uua.WriteFormalUUA(filename);
      } else {
        cout<<"no registers to delete."<<endl;
      }
    }
    return 0;
}

int main(int argc, char *argv[])
{
    int tds,tdms;
 
    cout<<"(c) 2006-2008 Tomas Herrman, version: "<<VER_STRING<<endl;
    srand((unsigned)time(0)); 
    if (argc==2) {
        ftime(&tmea);                                  // start time
        find_tb(argv[1]);        
        get_tdelta(tmea,tds,tdms);
        cout<<"Analysis finished @ ";
        disp_tdelta(cout,tds,tdms);                    // display whole time
        cout<<endl;
    } else {
        usage(argv[0]);        
        return 1;
    }
    return e_ok;
}

/* END */
