// Pklad pouit parseru a prace s moji implementaci

#include <iostream>
#include "error.h"
#include "ruzcore.h"

#define filename "pdex.ruz" 

tuua uua;                         // Unit Under Analysis - reprezentuje obvod

using namespace std;

int main(int argc, char *argv[])
{
// dale nasleduje par prikladu, ktere me ted v rychlosti napadly :o)

  cout<<"Nacitam UUA...   "<<flush;
// nacteni uua ze souboru "pdex.ruz" a pripadne zobrazeni chyb
  cout<<GetErrStr(uua.LoadFormalUUA(filename))<<endl<<endl;

// zjisteni velikosti mnozin
  cout<<uua.E.size()<<endl;      // pocet obvodovych prvku
  cout<<uua.P.size()<<endl;      // poce vsech bran krome primarnich
  cout<<uua.I.size()<<endl;      // pocet vsech I-cest v obvodu
  cout<<endl;
// ...



// vypsani vsech prvku mnozin
// typ telset, vypsani napr. vsech prvku v obvodu
  telset::iterator it_el;        // definice promenne it_el

  for (it_el=uua.E.begin();it_el!=uua.E.end();it_el++)
    cout<<*it_el<<" ";
  cout<<endl<<endl;
  
// typ tpairset, vypsani napr vsech spoju v obvodu
  tpairset::iterator it_pair;    // definice promenne it_pair

  for (it_pair=uua.C.begin();it_pair!=uua.C.end();it_pair++)
  {
    cout<<"("<<
    (*it_pair).f<<               // zacatek spoje
    ","<<
    (*it_pair).s<<               // konec spoje
    ") ";
  }
  cout<<endl<<endl;
// ...



// vypsani ID vsech prvku, ktere jsou registry 
// (ve VHDL napr. definovany jako typ REGISTER_D)
// vyuzijeme mnozinu, ktera mapuje ID prvku na typ (mnozina ELT)
  tgnames::iterator it_elt;      // definice promenne it_elt

  for (it_elt=uua.ELT.begin();it_elt!=uua.ELT.end();it_elt++)
    if ((*it_elt).second=="REGISTER_D")  // testujeme na pozadovany typ
      cout<<(*it_elt).first<<" ";   // v pripade shody vypiseme ID prvku
  cout<<endl<<endl;

// zjisteni ktere brany prislusi k prvku s nazvem MUX1
// nejdrive musime zjistit ID prvku, ktery ma nazev MUX1
// sekvencne prohledame mnozinu, ktera popisuje mapovani ID na nazev
// prvku (mnozina ELN)
  tgnames::iterator it_eln;      // definice promenne it_eln
  tidsetmap::iterator it_sm;     // definice promenne it_sm
  telset::iterator it_el2;       // definice promenne it_el2
 
  it_eln=uua.ELN.begin();
  while (((*it_eln).second!="MUX1")&&(it_eln!=uua.ELN.end()))
    it_eln++;  
  
  if (it_eln!=uua.ELN.end())    // pokud pozadovany prvek existuje
  {
// tak vypiseme vsechny ID mu prislusejicich bran
// k tomu vyuzijeme mnoziny PSI a dale vypiseme nazvy kazde brany,
// na to pouzijeme mnozinu GN
    if ((it_sm=uua.PSI.find((*it_eln).first))!=uua.PSI.end())  // ma-li zaznam 
    // v PSI,mel by mit, jinak by to znamenalo, ze se nekde stala nejaka chyba a
    // UUA model je nekonzistentni
      for (it_el2=(*it_sm).second.begin();it_el2!=(*it_sm).second.end();
           it_el2++)            // projdeme vsechny brany prvku
      {
        cout<<*it_el2<<" = ";    // vypiseme ID kazde brany
        // muzeme vyuzit jiz drive definovanou promennou it_eln, protoze
        // puvodni hodnota uz neni potreba
        if ((it_eln=uua.GN.find(*it_el2))!=uua.GN.end())
        // ma-li brana zaznam v GN (mela by mit)
          cout<<(*it_eln).second; // vypiseme jeji nazev
        cout<<endl<<endl;
      }    
  }


// zjisteni zda-li existuje I-cesta mezi branami s ID 1 a 6
  tsequence::iterator it_seq;       // definice promenne it_seq      
  tro::iterator it_ro;              // definice promenne it_ro      
  tdelta::iterator it_delta;        // definice promenne it_delta      

  // klicem je dvojice tpair
  if (uua.I.find(tpair(1,6))!=uua.I.end())
  {
  // delej neco...
  }
  
  // nebo jednoduseji vyuziti predikatu ipt
  if (uua.ipt(1,6))
  {
    // vypiseme prvni nalezenou posloupnost bran popisujici I-cestu (RO)
    // najdeme prvni posloupnost
    if ((it_ro=uua.RO.find(tpair(1,6)))!=uua.RO.end())
    {
      // vypiseme vsechny brany na I-ceste
      for (it_seq=(*it_ro).second.begin();it_seq!=(*it_ro).second.end();
           it_seq++)
        cout<<*it_seq<<" ";
      cout<<endl<<endl;
    }
    // vypiseme delku nejkratsi I-cesty mezi branami 1,6 (pocatecni a koncova
    // se nepocita      
    if ((it_delta=uua.DELTA.find(tpair(1,6)))!=uua.DELTA.end())
      cout<<"delka nejkratsi I-cesty (1,6): "<<(*it_delta).second;
    // pokud I-cesta neexistuje, jeji delka je nastavena na INT_MAX (definovano
    // v <climits>
    cout<<endl<<endl;
  }
  
      
 // zmena zaznamu delky nejkratsi I-cesty (1,4) z delky 8 na delku 6 
 // aby nedoslo k inkonzistenci je treba upravit i mnozinu RO (ale to 
 // se mi sem nechce psat :o)
  tdelta::iterator it_d;                     // definice promenne it_d
  tpair pair;                                // definice promenne pair

  pair.f=1;                                  // from (First)
  pair.s=4;                                  // to (Second)
  it_d=uua.DELTA.find(pair);
  if (it_d!=uua.DELTA.end())                 // DELTA update
    uua.DELTA.erase(pair);                   // vymazani pripadneho puvodniho
  uua.DELTA.insert(tdelta::value_type(pair,6));  // vlozeni noveho   

  return e_ok;
}
