/*
        Testable Blocks Detector - loop break
        =====================================
        Source File - loopbreak.cc
        Coded and assembled by: Ing. Tom Herrman <herrman@fitvutbr.cz>
                                UPSY FIT VUT 2007 http://www.fit.vutbr.cz/~herrman
        Date: 1/2008
        Version: 0.4
        
        Licence: This program can be copied and used without limitation only
                 with presentation header and author's name. 
        Thanks to: Yarda for Ruzicka's formal model core
*/

#define DEBUG

#ifndef ivector
#include <vector>
#define ivector
#endif

#include <iostream>
#include "error.h"
#include "ruzic.h"
#include "loopbreak_private.h"
#include "utils.h"
#include <string.h>
         
truua uua;
timeb tmea;
using namespace std;

void usage(char *pname) {
    cout<<endl;
    cout<<pname<<" unit"<<endl<<endl;
    cout<<"\tunit - filename of unit with .ruz"<<endl;
    return;
}

tid port2element(tid port)
{
    tidsetmap::iterator it_psi;
    telset::iterator it_set;
    
    for (it_psi=uua.PSI.begin();it_psi!=uua.PSI.end();it_psi++)
    {
        if(it_psi->second.count(port))
        {
            return it_psi->first;
        }
    }
    return 0;
}

bool isregister(tid id)
{
     return uua.R.count(id);
}

tid GetNode(tid port)
{
    tidsetmap::iterator it_V;

    for(it_V=uua.V.begin();it_V!=uua.V.end(); it_V++)
    {
      if(it_V->second.find(port)!=it_V->second.end())
        break;
    }
    if(it_V!=uua.V.end()) return it_V->first;
    else return 0;
}

int loopberak_run(char *nunit)
{
    terr e;
    telset::iterator it_r;
    telset::iterator it_CI;
    telset::iterator it_e;
    tidsetmap::iterator it_psi;
    telset::iterator it_p;
    tpairset::iterator it_C;
    tro::iterator it_ro,it_ro2;
    tsequence::iterator it_seq;
    telset setx;
    bool registerinloop,insertpair;
    unsigned int loops,bloops, vloops, bvloops;
    tro loopscut;
    unsigned x,regadds;
    tid port1,port2,pomnode,pomport;
    tsequence pomseq;
    tid newregister,newport1,newport2,newport3;
    char *poms;
    char pomstr[500];
    string pomstring;
    tmiel miel;
    int cutwidth;
    tpairset Ccopy;
    telset toprocess;
    telset processed;
    map<tid,tsequence> pathfromreg;
    tid processing;
    tid pathfromport,pompathport;
    tid pomelement;
    
    
    cout<<"Loading unit ("<<nunit<<")...";
    e=uua.LoadFormalUUA(nunit);
    if (e!=e_ok) {
        cout<<GetErrStr(e)<<endl<<endl;
        return 2;
    }
    cout<<"Done"<<endl;

    cout<<"Scanning circuit for loops..."<<endl;
    loops=bloops=0;
    for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
    {
      setx=uua.PSI[*it_r];
      for (it_ro=uua.RO.begin();it_ro!=uua.RO.end();it_ro++)
      {
          if((it_ro->first.f!=it_ro->first.s) && (setx.count(it_ro->first.f)) && (setx.count(it_ro->first.s))
             /*&& (it_ro->second.size()>2)*/ && (uua.OUTP.count(it_ro->first.f)) && (uua.INP.count(it_ro->first.s)))
          {
             registerinloop=false;
             for (it_seq=it_ro->second.begin();it_seq!=it_ro->second.end();it_seq++)
               if(!setx.count(*it_seq))
                 if(isregister(port2element(*it_seq))) registerinloop=true;
             if(!registerinloop)
             {
                 loops++;
                 loopscut.insert(tro::value_type(it_ro->first,it_ro->second));
#ifdef DEBUG                 
                 cout<<"R"<<*it_r;
                 cout<<" -> RO>("<<it_ro->first.f<<","<<it_ro->first.s<<"):";
                 for (it_seq=it_ro->second.begin();it_seq!=it_ro->second.end();it_seq++)
                 {
                   cout<<*it_seq;
                   if((it_seq+1)!=it_ro->second.end()) cout<<",";
                 }
                 cout<<";"<<endl;
#endif                 
             } else {
                 bloops++;
             }
          }
      }
    }
    cout<<"done."<<endl<<"# of nonbreakable loops: "<<loops<<"/"<<(bloops+loops)<<endl;

//------------------virtual loop detect----------------
    cout<<"Scanning circuit for virtual loops..."<<endl;
    bvloops=vloops=0;
    for (it_r=uua.R.begin();it_r!=uua.R.end();it_r++)
    {
      toprocess.clear();
      toprocess.insert(*it_r);
      processed.clear();
      pathfromreg.clear();
      pomseq.clear();
      pathfromreg[*it_r]=pomseq;
      setx=uua.PSI[*it_r];
      while(toprocess.size()>0)
      {
        processing=*(toprocess.begin());
        toprocess.erase(toprocess.begin());
        if(processed.count(processing)>0) continue;
        for (it_ro=uua.RO.begin();it_ro!=uua.RO.end();it_ro++)
        {
           if (it_ro->first.f==it_ro->first.s) continue;
           if ((it_ro->second.size()==2) && (setx.count(it_ro->first.f)) && (setx.count(it_ro->first.s))) continue;
           if ( (uua.PSI[processing].count(it_ro->first.f))) // start in element
           {
             registerinloop=false;
             it_seq=it_ro->second.begin();
             for (it_seq++;it_seq!=it_ro->second.end();it_seq++)
               if( ! ( ((it_seq+1)==it_ro->second.end()) && (setx.count(*it_seq)) ) )
                 if(isregister(port2element(*it_seq)))
                 {
                   registerinloop=true;
                   break;
                 }
             if(!registerinloop)
             {
               pomseq.clear();
               pomseq.insert(pomseq.end(),pathfromreg[processing].begin(),pathfromreg[processing].end());
               pomseq.insert(pomseq.end(),it_ro->second.begin(),it_ro->second.end());
               if(setx.count(it_ro->first.s))
               {
                 if (pathfromreg[processing].size()>0)
                 {
                   pathfromport=*(pathfromreg[processing].begin());
                   pompathport=*(pathfromreg[processing].rbegin());
                 } else{
                   pathfromport=it_ro->first.f;
                   pompathport=-1;
                 }
                 if( (pathfromport!=it_ro->first.s) && (uua.OUTP.count(pathfromport)) && (uua.INP.count(it_ro->first.s))
                      &&  (pompathport!=*(it_ro->second.begin())) && (pomseq.size()%2==0))
                 {  
                   for(it_ro2=loopscut.find(tpair(pathfromport,it_ro->first.s));it_ro2!=loopscut.end();it_ro2++)
                   {
                     if((it_ro2->first.f!=pathfromport) || (it_ro2->first.s!=it_ro->first.s))                 
                       break;
                     if(it_ro2->second==pomseq)
                     {
                       loopscut.erase(it_ro2);
                       break;
                     }
                   }
                   loopscut.insert( tro::value_type(tpair(pathfromport,it_ro->first.s),pomseq) );
#ifdef DEBUG                 
                   cout<<"R"<<*it_r<<" E"<<processing;
                   cout<<" -> RO>("<<pathfromport<<","<<it_ro->first.s<<"):";
                   for (it_seq=pomseq.begin();it_seq!=pomseq.end();it_seq++)
                   {
                     cout<<*it_seq;
                     if((it_seq+1)!=pomseq.end()) cout<<",";
                   }
                   cout<<";"<<endl;
#endif                 
                   vloops++;
                 }
                 bvloops++;
               } else {
                 pomelement=port2element(it_ro->first.s);
                 if(pomelement)
                 {
                   toprocess.insert(pomelement);
                   if (pomseq.size()%2==0)
                     if(pathfromreg.count(pomelement)==0)
                       pathfromreg[pomelement]=pomseq;
                 }
               }
             }
           }
           if ( (uua.PSI[processing].count(it_ro->first.s))) // end in element
           {
             registerinloop=false;
             for (it_seq=it_ro->second.begin();it_seq!=it_ro->second.end()-1;it_seq++)
               if( ! ( (it_seq==it_ro->second.begin()) && (setx.count(*it_seq)) ) )
                 if(isregister(port2element(*it_seq)))
                 {
                   registerinloop=true;
                   break;
                 }
             if(!registerinloop)
             {
               pomseq.clear();
               pomseq.insert(pomseq.end(),pathfromreg[processing].begin(),pathfromreg[processing].end());
               pomseq.insert(pomseq.end(),it_ro->second.rbegin(),it_ro->second.rend());
               if(setx.count(it_ro->first.f))
               {
                 if (pathfromreg[processing].size()>0)
                 {
                   pathfromport=*(pathfromreg[processing].begin());
                   pompathport=*(pathfromreg[processing].rbegin());
                 } else {
                   pathfromport=it_ro->first.s;
                   pompathport=-1;
                 }
                 if( (pathfromport!=it_ro->first.s) && (uua.OUTP.count(pathfromport)) && (uua.INP.count(it_ro->first.f))
                      &&  (pompathport!=*(it_ro->second.rbegin())) && (pomseq.size()%2==0) )
                 {
                   for(it_ro2=loopscut.find(tpair(pathfromport,it_ro->first.f));it_ro2!=loopscut.end();it_ro2++)
                   {
                     if((it_ro2->first.f!=pathfromport) || (it_ro2->first.s!=it_ro->first.f))                 
                       break;
                     if(it_ro2->second==pomseq)
                     {
                       loopscut.erase(it_ro2);
                       break;
                     }
                   }
                   loopscut.insert( tro::value_type(tpair(pathfromport,it_ro->first.f),pomseq) );
#ifdef DEBUG                 
                   cout<<"R"<<*it_r<<" E"<<processing;
                   cout<<" -> revRO>("<<pathfromport<<","<<it_ro->first.f<<"):";
                   for (it_seq=pomseq.begin();it_seq!=pomseq.end();it_seq++)
                   {
                     cout<<*it_seq;
                     if((it_seq+1)!=pomseq.end()) cout<<",";
                   }
                   cout<<";"<<endl;
#endif                 
                   vloops++;
                 }
                 bvloops++;
               } else {
                 pomelement=port2element(it_ro->first.f);
                 if(pomelement)
                 {
                   toprocess.insert(pomelement);
                   if (pomseq.size()%2==0)
                     if(pathfromreg.count(pomelement)==0)
                       pathfromreg[pomelement]=pomseq;
                 }
               }
             }
           }
        }
        processed.insert(processing);
      }
    }
    
    cout<<"done."<<endl<<"# of nonbreakable virtual loops: "<<vloops<<"/"<<bvloops<<endl;
#ifdef DEBUG                 
    for (it_ro2=loopscut.begin();it_ro2!=loopscut.end();it_ro2++)
    {
        cout<<"LC("<<it_ro2->first.f<<","<<it_ro2->first.s<<"/";
        for (it_seq=it_ro2->second.begin();it_seq!=it_ro2->second.end();it_seq++)
        {
          cout<<*it_seq;
          if((it_seq+1)!=it_ro2->second.end()) cout<<",";
        }
        cout<<")"<<endl;
    }
#endif                 

//    return 0;
//-----------------------------------------------------

    cout<<"Preparing new register and his ports... "<<endl;
    newregister=(*(uua.E.rbegin()))+1;
    newport1=(*(uua.P.rbegin()))+1;
    newport2=newport1+1;
    newport3=newport2+1;
    regadds=0;
    for (it_ro2=loopscut.begin();it_ro2!=loopscut.end();it_ro2++)
    {
      cout<<"R"<<newregister<<"("<<newport1<<","<<newport2<<","<<newport3<<")-";
      x=it_ro2->second.size();
      if(x>=6) {
        x=x-4;
        x=x/2;
        x=(rand()%x)*2;
        x+=2;
      } else {
        x=x/2;
        x=(rand()%x)*2;
      }
      it_seq=it_ro2->second.begin();      
      it_seq=it_seq+x;
      port1=*it_seq;
      it_seq++;
      port2=*it_seq;
      cout<<"Br.conn.("<<port1<<","<<port2<<") ";
      if(uua.C.count(tpair(port1,port2))==0)
      {
        cout<<"connection error, cannot be break here!!";
      } else {
        regadds++;
        cout<<"set E(";
        uua.E.insert(newregister);
        cout<<newregister<<"), set R(";
        uua.R.insert(newregister);
        cout<<newregister<<"), ELN(";
        sprintf(pomstr,"Rx%d",regadds);
        pomstring=pomstr;
        cout<<pomstring<<"),";
        uua.ELN.insert(tgnames::value_type(newregister,pomstring));
        cout<<"ELT(";
        pomstring="xdff";
        cout<<pomstring<<"),";
        uua.ELT.insert(tgnames::value_type(newregister,pomstring));
        cout<<"INP(";
        cout<<newport1<<"),";
        uua.INP.insert(newport1);
        cout<<"OUTP(";
        cout<<newport2<<"),";
        uua.OUTP.insert(newport2);
        cout<<"CI(";
        cout<<newport3<<"),";
        uua.CI.insert(newport3);
        cout<<"MI(";
        cout<<newport1<<","<<newport2<<"),";
        miel.clear();
        miel.insert(tidstrpair(newport3,"==^"));
        uua.MI.insert(tmi::value_type(tpair(newport1,newport2),miel));
        cout<<"GN(";
        cout<<newport1<<"-D,"<<newport2<<"-Q,"<<newport3<<"-CLK),";
        uua.GN.insert(tgnames::value_type(newport1,"D"));
        uua.GN.insert(tgnames::value_type(newport2,"Q"));
        uua.GN.insert(tgnames::value_type(newport3,"CLK"));
        cout<<"WIDTH(";
        cutwidth=uua.WIDTH[port1];
        cout<<cutwidth<<"),";
        uua.WIDTH.insert(tidintmap::value_type(newport1,cutwidth));
        uua.WIDTH.insert(tidintmap::value_type(newport2,cutwidth));
        uua.WIDTH.insert(tidintmap::value_type(newport3,1));
        cout<<"PSI(";
        cout<<newregister<<"),";
        setx.clear();
        setx.insert(newport1);
        setx.insert(newport2);
        setx.insert(newport3);
        uua.PSI.insert(tidsetmap::value_type(newregister,setx));
        cout<<"P(";
        cout<<newport1<<","<<newport2<<","<<newport3<<"),";
        uua.P.insert(newport1);
        uua.P.insert(newport2);
        uua.P.insert(newport3);
        cout<<"M(";
        cout<<newport1<<","<<newport2<<"),";
        uua.M.insert(tpair(newport1,newport2));
        cout<<"C(";
        cout<<port1<<","<<newport1<<";"<<port2<<","<<newport2<<"),";
        Ccopy.clear();
        Ccopy.insert(uua.C.begin(),uua.C.end());
        for (it_C=Ccopy.begin();it_C!=Ccopy.end();it_C++)
        {
            if(it_C->f==port2)
              uua.C.erase(*it_C);
            if(it_C->s==port2)
              uua.C.erase(*it_C);
            if(it_C->f==port1)
              uua.C.insert(tpair(newport1,it_C->s));
            if(it_C->s==port1)
              uua.C.insert(tpair(it_C->f,newport1));
        }
        Ccopy.clear();
        uua.C.insert(tpair(newport1,newport1));
        uua.C.insert(tpair(newport2,newport2));
        uua.C.insert(tpair(port1,newport1));
        uua.C.insert(tpair(port2,newport2));
        uua.C.insert(tpair(newport2,port2));
        uua.C.insert(tpair(newport1,port1));
        cout<<"I(";
        for (it_C=uua.I.begin();it_C!=uua.I.end();it_C++)
        {
            if(it_C->f==port2) {
              uua.I.insert(tpair(newport1,it_C->s));
              uua.I.insert(tpair(newport2,it_C->s));
            }
            if(it_C->s==port1) {
              uua.I.insert(tpair(it_C->f,newport1));
              uua.I.insert(tpair(it_C->f,newport2));
            }
        }
        uua.I.insert(tpair(newport1,newport1));
        uua.I.insert(tpair(newport2,newport2));
        cout<<"),";
        cout<<"II(";
        for (it_C=uua.II.begin();it_C!=uua.II.end();it_C++)
        {
            if(it_C->f==port2) {
              uua.II.insert(tpair(newport1,it_C->s));
              uua.II.insert(tpair(newport2,it_C->s));
            }
            if(it_C->s==port1) {
              uua.II.insert(tpair(it_C->f,newport1));
              uua.I.insert(tpair(it_C->f,newport2));
            }
        }
        cout<<"),";
        cout<<"V(";
        pomnode=GetNode(port2);
        cout<<pomnode<<",";
        uua.V[pomnode].erase(port2);
        uua.V[pomnode].insert(newport1);
        setx.clear();
        setx.insert(port2);
        setx.insert(newport2);
        pomnode=(uua.V.rbegin()->first)+1;
        cout<<pomnode;
        uua.V.insert(tidsetmap::value_type(pomnode,setx));
        cout<<"),";
        cout<<"C/V-clk(";
        pomport=*uua.CI.begin();
        for(it_CI=uua.CI.begin();it_CI!=uua.CI.end();it_CI++)
        {
          if( strcasecmp(uua.GN[*it_CI].c_str(),"ck")==0 )
          {
              pomport=*it_CI;
              break;
          }
          if( strcasecmp(uua.GN[*it_CI].c_str(),"clk")==0 )
          {
              pomport=*it_CI;
              break;
          }
          if( strcasecmp(uua.GN[*it_CI].c_str(),"clock")==0 )
          {
              pomport=*it_CI;
              break;
          }
        }
        pomnode=GetNode(pomport);
        uua.V[pomnode].insert(newport3);
        for (it_p=uua.V[pomnode].begin();it_p!=uua.V[pomnode].end();it_p++)
        {
           uua.C.insert(tpair(newport3,*it_p));
           uua.C.insert(tpair(*it_p,newport3));
        }
        uua.C.insert(tpair(newport3,newport3));
        cout<<"),";
        cout<<"RO/DELTA(";
        uua.RO.erase(tpair(port2,port1));
        for (it_ro=uua.RO.begin();it_ro!=uua.RO.end();it_ro++)
        {
            if(it_ro->first.f==port2) {
              pomseq=it_ro->second;
              pomseq.insert(pomseq.begin(),newport2);
              pomseq.insert(pomseq.begin(),newport1);
              uua.RO.insert(tro::value_type(tpair(newport1,it_ro->first.s),pomseq));
              if(uua.DELTA.count(it_ro->first))
                uua.DELTA.insert(tdelta::value_type(tpair(newport1,it_ro->first.s),uua.DELTA[it_ro->first]+1));
              pomseq=it_ro->second;
              pomseq.insert(pomseq.begin(),newport2);
              uua.RO.insert(tro::value_type(tpair(newport2,it_ro->first.s),pomseq));
              if(uua.DELTA.count(it_ro->first))
                uua.DELTA.insert(tdelta::value_type(tpair(newport2,it_ro->first.s),uua.DELTA[it_ro->first]));

            }
            if(it_ro->first.s==port1) {
              pomseq=it_ro->second;
              pomseq.insert(pomseq.end(),newport1);
              uua.RO.insert(tro::value_type(tpair(it_ro->first.f,newport1),pomseq));
              if(uua.DELTA.count(it_ro->first))
                uua.DELTA.insert(tdelta::value_type(tpair(it_ro->first.f,newport1),uua.DELTA[it_ro->first]));
              pomseq=it_ro->second;
              pomseq.insert(pomseq.end(),newport1);
              pomseq.insert(pomseq.end(),newport2);
              uua.RO.insert(tro::value_type(tpair(it_ro->first.f,newport2),pomseq));
              if(uua.DELTA.count(it_ro->first))
                uua.DELTA.insert(tdelta::value_type(tpair(it_ro->first.f,newport2),uua.DELTA[it_ro->first]+1));
            }
        }
        for (it_ro=uua.RO.begin();it_ro!=uua.RO.end();it_ro++)
        {
            pomseq.clear();
            insertpair=false;
            for (it_seq=it_ro->second.begin();it_seq!=it_ro->second.end();it_seq++)
            {
                if( ((*it_seq)==port2) && ( (it_seq==it_ro->second.begin()) || (*(it_seq-1)!=newport2) ) )
                {
                  insertpair=true;                    
                  pomseq.insert(pomseq.end(),newport1);
                  pomseq.insert(pomseq.end(),newport2);
                }
                pomseq.insert(pomseq.end(),*it_seq);
            }
            if(insertpair)
            {
              it_ro->second=pomseq;
              if(uua.DELTA.count(it_ro->first))
                uua.DELTA[it_ro->first]++;
/*              cout<<it_ro->first.f<<","<<it_ro->first.s<<"-";
              for (it_seq=it_ro->second.begin();it_seq!=it_ro->second.end();it_seq++)
                cout<<*it_seq<<",";            
              cout<<"; ";*/
            }
        }
        pomseq.clear();
        pomseq.insert(pomseq.end(),newport1);
        pomseq.insert(pomseq.end(),port1);
        uua.RO.insert(tro::value_type(tpair(newport1,port1),pomseq));
        pomseq.insert(pomseq.end(),newport2);
        pomseq.insert(pomseq.end(),port2);
        uua.RO.insert(tro::value_type(tpair(newport2,port2),pomseq));
        cout<<"),";
        
        
        newregister++;
        newport1=newport3+1;
        newport2=newport1+1;
        newport3=newport2+1;
      }
      cout<<endl;
    }

    poms=strstr(nunit,".");
    if(poms) *poms=0;
    strcpy(pomstr,nunit);
    strcat(pomstr,"_noloop.ruz");
    cout<<"Writing file ("<<pomstr<<") ";
    uua.WriteFormalUUA(pomstr);
    cout<<"done."<<endl;;
    return 0;
}

int main(int argc, char *argv[])
{
    int tds,tdms;

    srand((unsigned)time( NULL ));  
    cout<<"(c) 2007-2008 Tomas Herrman, version: "<<VER_STRING<<endl;
    srand((unsigned)time(0)); 
    if (argc==2) {
        ftime(&tmea);                                  // start time
        loopberak_run(argv[1]);        
        get_tdelta(tmea,tds,tdms);
        cout<<"Analysis finished @ ";
        disp_tdelta(cout,tds,tdms);                    // display whole time
        cout<<endl;
    } else {
        usage(argv[0]);        
        return 1;
    }
    return e_ok;
}

/* END */
