//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsThreadTEST.cpp                   \n
 * Section: libSystemTEST                       \n
 * Date:    2003/11/01                          \n
 *
 * $Id: mdsThreadTEST.cpp 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Testing of the mds::CThread class.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/System/mdsCriticalSection.h>
#include <MDSTk/System/mdsSleep.h>
#include <MDSTk/System/mdsThread.h>

// STL
#include <iostream>


//==============================================================================
/*
 * Global constants.
 */

//! The number of threads
#define THREADS                 5

//! Delay after releasing mutex
#define DELAY                   50

//! Smart pointer to critical section
mds::sys::CCriticalSectionPtr   spCritSection;


//==============================================================================
/*!
 * Thread routine
 */
MDS_THREAD_ROUTINE(thread)
{
    int id = *((int *)pThread->getData());

    MDS_THREAD_MAIN_LOOP
    {
        spCritSection->enter();
        std::cout << "Thread: " << id << std::endl;
        spCritSection->leave();
        mds::sys::sleep(DELAY + DELAY * id);
    }

    spCritSection->enter();
    std::cout << "Thread: " << id << " terminated" << std::endl;
    spCritSection->leave();

    return 0;
}


//==============================================================================
/*!
 * main
 */
int main(int argc, const char *argv[])
{
    // Threads
    mds::sys::CThread *ppThreads[THREADS];
    int piThreadsId[THREADS];

    // Creation of all ppThreads
    for( int i = 0; i < THREADS; i++ )
    {
        piThreadsId[i] = i;
        ppThreads[i] = new mds::sys::CThread(thread, (void *)&piThreadsId[i], true);
    }

    // Sleep
    mds::sys::sleep(10000);

    // Destroy all ppThreads
    for( int i = 0; i < THREADS; i++ )
    {
        ppThreads[i]->terminate(true, 1000);
        delete ppThreads[i];
    }

    return 0;
}

