//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsSemaphoreTEST.cpp                \n
 * Section: libSystemTEST                       \n
 * Date:    2003/11/04                          \n
 *
 * $Id: mdsSemaphoreTEST.cpp 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Testing of the mds::CSemaphore class.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/System/mdsSleep.h>
#include <MDSTk/System/mdsThread.h>
#include <MDSTk/System/mdsSemaphore.h>

#include <cstring>
#include <cassert>

// STL
#include <iostream>
#include <string>


//==============================================================================
/*
 * Global constants and variables.
 */

//! The number of threads
#define THREADS     5

//! Delay after releasing semaphore
#define DELAY       200

//!    Named semaphore used for mutual exclusion
mds::sys::CSemaphore *pSemaphore    = NULL;

//! Name of the sempahore
const std::string SEMAPHORE_NAME    = "1234";


//==============================================================================
/*!
 * Generates random number
 */
unsigned random(const unsigned uiMax)
{
    return (1 + (unsigned int)(((double)rand() / RAND_MAX) * uiMax));
}


//==============================================================================
/*!
 * Thread routine
 */
MDS_THREAD_ROUTINE(thread)
{
    int id = *((int *)pThread->getData());

    MDS_THREAD_MAIN_LOOP
    {
        pSemaphore->lock();
        std::cout << "Thread: " << id << std::endl;
        mds::sys::sleep(random(DELAY));
        pSemaphore->unlock();
    }

    pSemaphore->lock();
    std::cout << "Thread: " << id << " terminated" << std::endl;
    pSemaphore->unlock();

    return 0;
}


//==============================================================================
int main(int argc, char* argv[])
{
    // Create/Open a named mutex
    bool bAlreadyExists = false;
    pSemaphore = new mds::sys::CSemaphore(1, &SEMAPHORE_NAME, &bAlreadyExists);
    if( bAlreadyExists )
    {
        std::cout << "Semaphore already exists." << std::endl;
    }

    // Threads
    mds::sys::CThread *ppThreads[THREADS];
    int piThreadsId[THREADS];

    // Creation of all threads
    for( int i = 0; i < THREADS; i++ )
    {
        piThreadsId[i] = i;
        ppThreads[i] = new mds::sys::CThread(thread, (void *)&piThreadsId[i], true);
    }

    // Sleep
    mds::sys::sleep(10000);

    // Destroy all ppThreads
    for( int i = 0; i < THREADS; i++ )
    {
        ppThreads[i]->terminate(true, 1000);
        delete ppThreads[i];
    }

    // Delete global variables
    delete pSemaphore;

    return 0;
}

