//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsManualEventTEST.cpp              \n
 * Section: libSystemTEST                       \n
 * Date:    2003/11/04                          \n
 *
 * $Id: mdsManualEventTEST.cpp 345 2007-06-11 13:23:09Z spanel $
 *
 * Description:
 * - Testing of the mds::CEvent class.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/System/mdsCriticalSection.h>
#include <MDSTk/System/mdsSleep.h>
#include <MDSTk/System/mdsThread.h>
#include <MDSTk/System/mdsEvent.h>

// STL
#include <iostream>


//==============================================================================
/*
 * Global constants.
 */

//! The number of threads
#define THREADS     5

//! Delay after releasing mutex
#define DELAY       500

//! Smart pointer to critical section
mds::sys::CCriticalSectionPtr   spCritSection(new mds::sys::CCriticalSection);

//! Smart pointer to manual reseted event
mds::sys::CEventPtr             spEvent(new mds::sys::CEvent(false, true));


//==============================================================================
/*!
 * Generates random number
 */
unsigned random(const unsigned uiMax)
{
    return (1 + (unsigned int)(((double)rand() / RAND_MAX) * uiMax));
}


//==============================================================================
/*!
 * Thread routine
 */
MDS_THREAD_ROUTINE(thread)
{
    int id = *((int *)pThread->getData());

    MDS_THREAD_MAIN_LOOP
    {
        if( spEvent->wait(random(DELAY)) )
    {
        spCritSection->enter();
            std::cout << "Thread: " << id << std::endl;
            spEvent->reset();
            spCritSection->leave();
        }
        else
        {
            spCritSection->enter();
            std::cout << "Thread: " << id << " timeout" << std::endl;
            spCritSection->leave();
        }
    }

    spCritSection->enter();
    std::cout << "Thread: " << id << " terminated" << std::endl;
    spCritSection->leave();

    return 0;
}


//==============================================================================
/*!
 * main
 */
int main(int argc, const char *argv[])
{
    // Threads
    mds::sys::CThread *ppThreads[THREADS];
    int piThreadsId[THREADS];

    // Creation of all ppThreads
    for( int i = 0; i < THREADS; i++ )
    {
        piThreadsId[i] = i;
        ppThreads[i] = new mds::sys::CThread(thread, (void *)&piThreadsId[i], true);
    }

    // Periodic signalling of the spEvent
    for( int j = 0 ; j < 10; j++ )
    {
        mds::sys::sleep(DELAY);
        spEvent->set();
    }

    // Destroy all ppThreads
    for( int i = 0; i < THREADS; i++ )
    {
        ppThreads[i]->terminate(true, 1000);
        delete ppThreads[i];
    }

    return 0;
}

