//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsEventTEST.cpp                    \n
 * Section: libSystemTEST                       \n
 * Date:    2003/11/04                          \n
 *
 * $Id: mdsFileBrowserTEST.cpp 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Testing of the mds::CFileBrowser class.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/System/mdsFileBrowser.h>

#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cassert>

// STL
#include <iostream>
#include <string>


//==============================================================================
/*
 * Global constants and variables.
 */

//! Maximal length of user input
const int MAX_USER_INPUT    = 64;

//! The number of items listed in a one page
const int PAGE_LENGTH       = 10;

//! Smart pointer to file browser
mds::sys::CFileBrowserPtr spFileBrowser;


//==============================================================================
int main(int argc, char* argv[])
{
    char pcTemp[MAX_USER_INPUT];

    // Get the current directory
    std::cout << "Current directory: "
    << spFileBrowser->getDirectory()
    << std::endl;

    // Read the directory
    std::cout << "Enter the directory: ";
    fgets(pcTemp, MAX_USER_INPUT, stdin);
    pcTemp[strlen(pcTemp) - 1] = '\0';
    std::string sDirectory = pcTemp;

    // Change the current directory
    if (!spFileBrowser->setDirectory(sDirectory))
    {
        std::cout << "Error: cannot change the directory" << std::endl;
        return 0;
    }

    // Read the filemask
    std::cout << "Enter the filemask: ";
    fgets(pcTemp, MAX_USER_INPUT, stdin);
    pcTemp[strlen(pcTemp) - 1] = '\0';
    std::string sFilemask = pcTemp;

    // List the directory
    std::cout << "Directory listing:" << std::endl;
    mds::sys::CFileBrowser::SFileAttr File;
    int iCount = 0;
    bool bResult = spFileBrowser->findFirst(sFilemask, File);
    while( bResult )
    {
        std::cout << ((File.m_bDirectory) ? "  d " : "    ")
        << File.m_sName
        << std::endl;

        if( (++iCount % PAGE_LENGTH) == 0 )
        {
            std::cout << "Press Enter to continue..." << std::endl;
            std::cin.get();
        }

        bResult = spFileBrowser->findNext(File);
    }

    return 0;
}

