//==============================================================================
/*!
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsConsoleTEST.h                    \n
 * Section: libModuleTEST                       \n
 * Date:    2003/11/25                          \n
 *
 * $Id: mdsConsoleTEST.h 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Testing of the mds::mod::CConsole class.
 * - Module reads data from input channel a writes them to the output.
 */

#ifndef MDS_CONSOLETEST_H
#define MDS_CONSOLETEST_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Test console application CConsoleTEST.
 */
class CConsoleTEST : public mds::mod::CModule
{
public:
    //! Standard method getClassName()
    MDS_CLASS_NAME(CConsoleTEST);

    //! Smart pointer type
    //! - Declares type tSmartPtr
    MDS_SHAREDPTR(CConsoleTEST);

public:
    //! Default constructor
    CConsoleTEST(const std::string& sDescription);

    //! Virtual destructor
    virtual ~CConsoleTEST();

protected:
    //! Virtual method called on startup
    virtual bool startup();

    //! Virtual method called by the processing thread
    virtual bool main();

    //! Called on console shutdown
    virtual void shutdown();

    //! Called on writing a usage statement
    virtual void writeExtendedUsage(std::ostream& Stream);
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CConsoleTEST::tSmartPtr     CConsoleTESTPtr;


#endif // MDS_CONSOLETEST_H

