//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsConsoleTEST.cpp                  \n
 * Section: libModuleTEST                       \n
 * Date:    2003/11/25                          \n
 *
 * $Id: mdsConsoleTEST.cpp 345 2007-06-11 13:23:09Z spanel $
 *
 * Description:
 * - Testing of the mds::mod::CConsole class.
 */

#include <MDSTk/System/mdsSleep.h>

#include "mdsConsoleTEST.h"

// STL
#include <iostream>
#include <string>


//==============================================================================
/*
 * Global module constants.
 */

//! Module description
const std::string MODULE_DESCRIPTION    = "Module writes copy of input data to the output channel";

//! Additional command line arguments
const std::string MODULE_ARGUMENTS      = "";


//==============================================================================
/*
 * Implementation of the class CConsoleTEST.
 */
CConsoleTEST::CConsoleTEST(const std::string& sDescription)
        : mds::mod::CModule(sDescription)
{
    allowArguments(MODULE_ARGUMENTS);
}


CConsoleTEST::~CConsoleTEST()
{
}


bool CConsoleTEST::startup()
{
    // Note
    MDS_LOG_NOTE("Module startup");

    // Test of existence of input and output channel
    if( getNumOfInputs() != 1 || getNumOfOutputs() != 1 )
    {
        MDS_CERR('<' << m_sFilename << "> Wrong number of input and output channels" << std::endl);
        return false;
    }

    // O.K.
    return true;
}


bool CConsoleTEST::main()
{
    // Note
    MDS_LOG_NOTE("Module main function");

    // I/O channels
    mds::mod::CChannel *pIChannel = getInput(0);
    mds::mod::CChannel *pOChannel = getOutput(0);

    // Is any input?
    if( !pIChannel->isConnected() )
    {
        return false;
    }

    // Buffer
    char pcBuffer[512];

    // Wait for data
    if( pIChannel->wait(1000) )
    {
        // Read data from the input channel
        int iCount = pIChannel->read(pcBuffer, 512);
        if( iCount > 0 )
        {
            if( !pOChannel->write(pcBuffer, iCount) )
            {
                MDS_LOG_ERROR("Cannot write data to the output channel");
            }
        }
    }
    else
    {
        MDS_LOG_NOTE("Wait timeout");
    }

    // Returning 'true' means to continue processing the input channel
    return true;
}


void CConsoleTEST::shutdown()
{
    // Note
    MDS_LOG_NOTE("Module shutdown");
}


void CConsoleTEST::writeExtendedUsage(std::ostream& Stream)
{
}


//==============================================================================
/*
 * Function main() which creates and executes console application.
 */
int main(int argc, char *argv[])
{
    // Creation of a module using smart pointer
    CConsoleTESTPtr spModule(new CConsoleTEST(MODULE_DESCRIPTION));

    // Initialize and execute the module
    if( spModule->init(argc, argv) )
    {
        spModule->run();
    }

    // Console application finished
    return 0;
}

