//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVectorTEST.cpp                   \n
 * Section: libBaseTEST                         \n
 * Date:    2003/12/04                          \n
 *
 * $Id:mdsVectorTEST.cpp 253 2006-02-20 09:56:33Z spanel $
 * 
 * Description:
 * - Testing of the mds::CVector template.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Math/mdsVector.h>
#include <MDSTk/Math/mdsVectorFunctions.h>

// STL
#include <iostream>


//==============================================================================
/*!
 * Prints a given vector
 */
void printVector(mds::math::CDVector& v)
{
    std::cout.setf(std::ios_base::fixed);
    std::cout << "  ";
    for( mds::tSize i = 0; i < v.getSize(); i++ )
    {
        std::cout << v(i) << " ";
    }
    std::cout << std::endl;
}


//==============================================================================
/*!
 * Waiting for a key
 */
void keypress()
{
    while( std::cin.get() != '\n' );
}


//==============================================================================
/*!
 * main
 */
int main(int argc, const char *argv[])
{
    mds::math::CDVector v1(4, 1);
    std::cout << "Vector 1" << std::endl;
    printVector(v1);
    keypress();

    mds::math::CDVector v2(4);
    std::cout << "Vector 2" << std::endl;
    for( mds::tSize j = 0; j < v2.getSize(); j++ )
    {
        v2(j) = j;
    }
    printVector(v2);
    keypress();

    std::cout << "Operation v1 += v2" << std::endl;
    v1 += v2;
    printVector(v1);
    keypress();

    mds::math::CDVectorPtr spV3(new mds::math::CDVector(8, 0));
    std::cout << "New smart pointer to vector 3" << std::endl;
    printVector(*spV3);
    keypress();

    mds::math::CDVector v31(*spV3, 0, 4, mds::REFERENCE);
    std::cout << "Reference v31" << std::endl;
    printVector(v31);
    keypress();

    mds::math::CDVector v32(*spV3, 4, 4, mds::REFERENCE);
    std::cout << "Reference v32" << std::endl;
    printVector(v32);
    keypress();

    std::cout << "Operation v31 = v2, v32 = v1" << std::endl;
    v31 += v2; v32 += v1;
    printVector(*spV3);
    keypress();

    std::cout << "Operation v31 *= 2, v32 += 10" << std::endl;
    v31 *= 2; v32 += 10;
    printVector(*spV3);
    keypress();

    std::cout << "Operation getMin(), getMax(), getSum(), getMean()" << std::endl;
    std::cout << "  " << mds::math::getMin<double>(*spV3)
    << "  " << mds::math::getMax<double>(*spV3)
    << "  " << mds::math::getSum<double>(*spV3)
    << "  " << mds::math::getMean<double>(*spV3)
    << std::endl;
    keypress();

    std::cout << "Operation v1.subSample(*spV3, 2)" << std::endl;
    v1.subSample(*spV3, 2);
    printVector(v1);
    keypress();

    std::cout << "Vector 2" << std::endl;
    printVector(v2);
    keypress();

    std::cout << "Operation spV3->concat(v1, v2)" << std::endl;
    spV3->concat(v1, v2);
    printVector(*spV3);
    keypress();

    std::cout << "Operation spV3->clip(2, 8)" << std::endl;
    spV3->clip(2, 8);
    printVector(*spV3);
    keypress();

    std::cout << "Operation v31.create(16, 5)" << std::endl;
    v31.create(16, 5);
    printVector(v31);
    keypress();

    std::cout << "Vector 3" << std::endl;
    printVector(*spV3);
    keypress();

    std::cout << "Vector 31" << std::endl;
    printVector(v31);
    keypress();

    std::cout << "Vector 32" << std::endl;
    printVector(v32);
    keypress();

    return 0;
}

