//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsStaticVectorTEST.cpp             \n
 * Section: libBaseTEST                         \n
 * Date:    2004/05/28                          \n
 *
 * $Id:mdsStaticVectorTEST.cpp 253 2006-02-20 09:56:33Z spanel $
 * 
 * Description:
 * - Testing of the mds::CStaticVector template.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Math/mdsStaticVector.h>

// STL
#include <iostream>


//==============================================================================
/*!
 * Prints a given vector
 */
void printVector(mds::math::CDVector3& v)
{
    std::cout.setf(std::ios_base::fixed);
    std::cout << "  ";
    for( mds::tSize i = 0; i < v.getSize(); i++ )
    {
        std::cout << v(i) << " ";
    }
    std::cout << std::endl;
}


//==============================================================================
/*!
 * Waiting for a key
 */
void keypress()
{
    while( std::cin.get() != '\n' );
}


//==============================================================================
/*!
 * main
 */
int main(int argc, const char *argv[])
{
    mds::math::CDVector3 v1(0);
    std::cout << "Vector 1" << std::endl;
    printVector(v1);
    keypress();

    mds::math::CDVector3 v2;
    std::cout << "Vector 2" << std::endl;
    for( mds::tSize j = 0; j < v2.getSize(); j++ )
    {
        v2(j) = j;
    }
    printVector(v2);
    keypress();

    std::cout << "Operation v1 += v2" << std::endl;
    v1 += v2;
    printVector(v1);
    keypress();

    std::cout << "Operation v1 *= 2" << std::endl;
    v1 *= 2;
    printVector(v1);
    keypress();

    std::cout << "Operation v2 += 10" << std::endl;
    v2 += 10;
    printVector(v2);
    keypress();

    std::cout << "Operation v1.zeros()" << std::endl;
    v1.zeros();
    printVector(v1);
    keypress();

    std::cout << "Operation v2.ones()" << std::endl;
    v2.ones();
    printVector(v2);
    keypress();

    return 0;
}

