//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsStaticMatrixTEST.cpp             \n
 * Section: libBaseTEST                         \n
 * Date:    2003/12/04                          \n
 *
 * $Id:mdsStaticMatrixTEST.cpp 253 2006-02-20 09:56:33Z spanel $
 * 
 * Description:
 * - Testing of the mds::CStaticMatrix template.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Math/mdsStaticMatrix.h>
#include <MDSTk/Math/mdsStaticVector.h>

// STL
#include <iostream>


//==============================================================================
/*!
 * Prints a given matrix
 */
void printMatrix(mds::math::CDMatrix3x3& m)
{
    std::cout.setf(std::ios_base::fixed);
    for( mds::tSize i = 0; i < m.getNumOfRows(); ++i )
    {
        std::cout << "  ";
        for( mds::tSize j = 0; j < m.getNumOfCols(); ++j )
        {
            std::cout << m(i,j) << " ";
        }
        std::cout << std::endl;
    }
}


//==============================================================================
/*!
 * Prints a given vector
 */
void printVector(mds::math::CDVector3& v)
{
    std::cout.setf(std::ios_base::fixed);
    std::cout << "  ";
    for( mds::tSize i = 0; i < v.getSize(); i++ )
    {
        std::cout << v(i) << " ";
    }
    std::cout << std::endl;
}


//==============================================================================
/*!
 * Waiting for a key
 */
void keypress()
{
    while( std::cin.get() != '\n' );
}


//==============================================================================
/*!
 * main
 */
int main(int argc, const char *argv[])
{
    mds::math::CDMatrix3x3 m1;
    std::cout << "Unit matrix 1" << std::endl;
    m1.unit();
    printMatrix(m1);
    keypress();

    mds::math::CDMatrix3x3 m2;
    std::cout << "Matrix 2" << std::endl;
    mds::tSize i, j;
    for( i = 0; i < m2.getNumOfRows(); i++ )
    {
        for( j = 0; j < m2.getNumOfCols(); j++ )
        {
            m2(i,j) = i * m1.getNumOfCols() + j;
        }
    }
    printMatrix(m2);
    keypress();

    std::cout << "Operation m1 += m2" << std::endl;
    m1 += m2;
    printMatrix(m1);
    keypress();

    std::cout << "Operation m2 *= 2" << std::endl;
    m2 *= 2;
    printMatrix(m2);
    keypress();

    mds::math::CDMatrix3x3 m3;
    std::cout << "Operation m3.mult(m1, m2)" << std::endl;
    m3.mult(m1, m2);
    printMatrix(m3);
    keypress();

    std::cout << "Matrix m1" << std::endl;
    for( i = 0; i < m1.getNumOfRows(); i++ )
    {
        for( j = 0; j < m1.getNumOfCols(); j++ )
        {
            m1(i,j) += i * m1.getNumOfCols() + j;
        }
    }
    printMatrix(m1);
    keypress();

    mds::math::CDVector3 v1;
    std::cout << "Vector 1" << std::endl;
    for( mds::tSize j = 0; j < v1.getSize(); j++ )
    {
        v1(j) = j;
    }
    printVector(v1);
    keypress();

    mds::math::CDVector3 v2;
    std::cout << "Operation v2.mult(m1, v1)" << std::endl;
    v2.mult(m1, v1);
    printVector(v2);
    keypress();

    std::cout << "Operation v2.mult(v1, m1)" << std::endl;
    v2.mult(v1, m1);
    printVector(v2);
    keypress();

    return 0;
}

