//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsFuzzyCMeansTEST.cpp              \n
 * Section: libMathTEST                         \n
 * Date:    2006/09/15                          \n
 *
 * $Id:$
 *
 * Description:
 * - Testing of the mds::math::CFuzzyCMeans template.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Math/mdsVector.h>
#include <MDSTk/Math/mdsVectorFunctions.h>

// Enable logging
#define FCM_LOGGING_ENABLED

#include <MDSTk/Math/Algorithm/mdsFuzzyCMeans.h>

// STL
#include <iostream>


//==============================================================================
/*
 * Global constants.
 */

//! Number of input samples.
const mds::tSize NUM_OF_SAMPLES = 1000;


//==============================================================================
/*!
 * Prints a given vector.
 */
void printVector(mds::math::CFVector& v)
{
    std::cout.setf(std::ios_base::fixed);
    std::cout << "  ";
    for( mds::tSize i = 0; i < v.getSize(); i++ )
    {
        std::cout << v(i) << " ";
    }
    std::cout << std::endl;
}


//==============================================================================
/*!
 * Waiting for a key.
 */
void keypress()
{
    while( std::cin.get() != '\n' );
}


//==============================================================================
/*!
 * main
 */
int main(int argc, const char *argv[])
{
    // Init global log
    MDS_LOG_INIT_STDERR;
//    MDS_LOG_INIT_FILE("temp.log");

    // One third of all samples
    mds::tSize THIRD = NUM_OF_SAMPLES / 3;

    std::cout << "Vector 1" << std::endl;
    mds::math::CFVector v2, v1(NUM_OF_SAMPLES, 1);
    v2.create(v1, THIRD, THIRD, mds::REFERENCE);
    v2.fill(2);
    v2.create(v1, 2 * THIRD, THIRD, mds::REFERENCE);
    v2.fill(3);
    printVector(v1);
    keypress();

    mds::math::CFuzzyCMeans<mds::math::CFVector,1> Clustering;
//    if( !Clustering.execute(v1, 3) )
    if( !Clustering.execute(v1) )
    {
        std::cout << "Error: Fuzzy C-Means algorithm failed!" << std::endl;
        return 0;
    }
    
    mds::math::CFuzzyCMeans<mds::math::CFVector,1>::tCluster c;
    std::cout << "Number of clusters: " << Clustering.getNumOfClusters() << std::endl;
    for( mds::tSize i = 0; i < Clustering.getNumOfClusters(); ++i )
    {
        Clustering.getCluster(i, c);
        std::cout << "  Cluster " << i << ": " << c << std::endl;
    }

    mds::math::CFuzzyCMeans<mds::math::CFVector,1>::tVector v;
    std::cout << "Membership function:"<< std::endl;
    Clustering.getMembership(150, v);
    std::cout << "  Sample 150: " << v << std::endl;
    Clustering.getMembership(450, v);
    std::cout << "  Sample 450: " << v << std::endl;
    Clustering.getMembership(750, v);
    std::cout << "  Sample 750: " << v << std::endl;

    return 0;
}

