//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsSingletonTEST.cpp                \n
 * Section: libBaseTEST                         \n
 * Date:    2004/11/22                          \n
 *
 * $Id: mdsSingletonTEST.cpp 64 2006-08-11 08:45:24Z spanel $
 * 
 * Description:
 * - Testing of the mds::CSingleton template.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsSingleton.h>

// STL
#include <iostream>


//==============================================================================
/*!
 * Singleton CA.
 * - Short longevity.
 * - Public constructor allows user instantiation!
 */
class CA : public mds::base::CSingleton<mds::base::SL_SHORT>
{
public:
    //! Default constructor
    CA() { std::cout << "  CA::CA()" << std::endl; }

    //! Destructor
    ~CA() { std::cout << "  CA::~CA()" << std::endl; }

    //! Print message
    void print() { std::cout << "  CA::print()" << std::endl; }

};


//==============================================================================
/*!
 * Singleton CAA - short longevity.
 * - User cannot make instances :)
 */
class CAA : public mds::base::CSingleton<mds::base::SL_SHORT>
{
public:
    //! Destructor
    ~CAA() { std::cout << "  CAA::~CAA()" << std::endl; }

    //! Print a message
    void print() { std::cout << "  CAA::print()" << std::endl; }

private:
    //! Private constructor
    CAA() { std::cout << "  CAA::CAA()" << std::endl; }

    MDS_PRIVATE_SINGLETON(CAA);
};


//==============================================================================
/*!
 * Singleton CB.
 * - Middle longevity.
 * - Public constructor allows user instantiation!
 */
class CB : public mds::base::CSingleton<mds::base::SL_MIDDLE>
{
public:
    //! Default constructor.
    CB() { std::cout << "  CB::CB()" << std::endl; }

    //! Destructor.
    ~CB() { std::cout << "  CB::~CB()" << std::endl; }

    //! Print message.
    void print() { std::cout << "  CB::print()" << std::endl; }

};


//==============================================================================
/*!
 * Singleton CC.
 * - Long longevity.
 * - Public constructor allows user instantiation!
 */
class CC : public mds::base::CSingleton<mds::base::SL_LONG>
{
public:
    //! Default constructor.
    CC() { std::cout << "  CC::CC()" << std::endl; }

    //! Destructor.
    ~CC() { std::cout << "  CC::~CC()" << std::endl; }

    //! Print message.
    void print() { std::cout << "  CC::print()" << std::endl; }

};


//==============================================================================
/*!
 * Singleton CCC.
 * - Long longevity.
 * - User cannot make instances :)
 */
class CCC : public mds::base::CSingleton<mds::base::SL_LONG>
{
public:
    //! Destructor.
    ~CCC() { std::cout << "  CCC::~CCC()" << std::endl; }

    //! Print message.
    void print() { std::cout << "  CCC::print()" << std::endl; }

private:
    //! Private constructor.
    CCC() { std::cout << "  CCC::CCC()" << std::endl; }

    MDS_PRIVATE_SINGLETON(CCC);
};


//==============================================================================
/*!
 * Singleton CD.
 * - Default longevity.
 * - Public constructor allows user instantiation!
 */
class CD : public mds::base::CDefaultSingleton
{
public:
    //! Public constructor.
    CD() { std::cout << "  CD::CD()" << std::endl; }

    //! Destructor.
    ~CD() { std::cout << "  CD::~CD()" << std::endl; }

    //! Print message.
    void print() { std::cout << "  CD::print()" << std::endl; }

};


//==============================================================================
/*!
 * Singleton CS.
 * - Library longevity.
 * - Public constructor allows user instantiation!
 */
class CS : public mds::base::CLibrarySingleton
{
public:
    //! Public constructor.
    CS() { std::cout << "  CS::CS()" << std::endl; }

    //! Destructor.
    ~CS() { std::cout << "  CS::~CS()" << std::endl; }

    //! Print message.
    void print() { std::cout << "  CS::print()" << std::endl; }

};


//==============================================================================
/*!
 * Waiting for a key.
 */
void keypress()
{
    while( std::cin.get() != '\n' );
}


//==============================================================================
/*!
 * Gets the singleton instances.
 */
void getInstances()
{
    // Get the singleton instances
    CS& S = MDS_SINGLETON(CS);
    CA& A = MDS_SINGLETON(CA);
    CC& C = MDS_SINGLETON(CC);
    CB& B = MDS_SINGLETON(CB);
    CD& D = MDS_SINGLETON(CD);
    CAA& AA = MDS_SINGLETON(CAA);
    CCC& CC = MDS_SINGLETON(CCC);

    // Call the print() method
    S.print();
    A.print();
    C.print();
    B.print();
    D.print();
    AA.print();
    CC.print();
}


//==============================================================================
/*!
 * main
 */
int main(int argc, const char *argv[])
{
    std::cout << "Get Singleton Instances 1" << std::endl;
    getInstances(); keypress();

    std::cout << "Get Singleton Instances 2" << std::endl;
    getInstances(); keypress();

    std::cout << "Exit" << std::endl;

    return 0;
}

