//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsBasePtrTEST.cpp                  \n
 * Section: libBaseTEST                         \n
 * Date:    2004/11/22                          \n
 *
 * $Id: mdsBasePtrTEST.cpp 345 2007-06-11 13:23:09Z spanel $
 * 
 * Description:
 * - Testing of the mds::CBasePtr template.
 */

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsBasePtr.h>

// STL
#include <iostream>


//==============================================================================
/*!
 * Class CA
 */
class CA
{
public:
    //! Allow class instantiation by smart pointer
    MDS_BASEPTR(CA);

public:
    //! Internal data
    int m_iData;

public:
    //! Constructor
    CA() : m_iData(0)
    {
        std::cout << "  <" << this << "> CA::CA()" << std::endl;
    }

    //! Constructor
    CA(int iData) : m_iData(iData)
    {
        std::cout  << "  <" << this << "> CA::CA(" << iData << ")" << std::endl;
    }

    //! Constructor
    CA(int *piData) : m_iData(*piData)
    {
        std::cout  << "  <" << this << "> CA::CA(" << *piData << ")" << std::endl;
    }

    //! Copy constructor
    CA(const CA& a) : m_iData(a.m_iData)
    {
        std::cout  << "  <" << this << "> CA::CA(" << &a << ")" << std::endl;
    }

    //! Destructor
    ~CA()
    {
        std::cout << "  <" << this << "> CA::~CA()" << std::endl;
    }

    //! Print message
    void print()
    {
        std::cout << "  <" << this << "> CA::m_iData = " << m_iData << std::endl;
    }
};

//! Base pointer to the class CA
typedef mds::base::CBasePtr<CA> CAPtr;


//==============================================================================
/*!
 * Waiting for a key
 */
void keypress()
{
    while( std::cin.get() != '\n' );
}


//==============================================================================
/*!
 * main
 */
int main(int argc, const char *argv[])
{
    std::cout << "Create CBasePtr<CA> p1 using CA() default constructor" << std::endl;
    CAPtr p1(new CA());
    p1->print();
    keypress();

    std::cout << "Create p2 using CA(const int) constructor" << std::endl;
    {
        CAPtr p2(new CA(10));
        p2->print();
        keypress();
    }

    std::cout << "Print p1" << std::endl;
    p1->print();
    keypress();

    std::cout << "Create p2 using CA(const int *) constructor" << std::endl;
    {
        int data = 20;
        CAPtr p2(new CA(&data));
        p2->print();
        keypress();
    }

    std::cout << "Print p1" << std::endl;
    p1->print();
    keypress();

    std::cout << "Create p2 using CBasePtr::CBasePtr(const CBasePtr&)" << std::endl;
    {
        CAPtr p2(p1);
        p2->print();
        keypress();

        std::cout << "Increment data of the p2" << std::endl;
        p2->m_iData += 1;
        p2->print();
        keypress();
    }

    std::cout << "Print p1" << std::endl;
    p1->print();
    keypress();

    std::cout << "Create CBasePtr p2 using copy constructor CA::CA(const CA&)" << std::endl;
    {
        CAPtr p2(new CA(*p1));
        p2->print();
        keypress();

        std::cout << "Increment data of the p2" << std::endl;
        p2->m_iData += 1;
        p2->print();
        keypress();
    }

    std::cout << "Print p1" << std::endl;
    p1->print();
    keypress();

    std::cout << "Exit" << std::endl;

    return 0;
}

