//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (C) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVolumeThresholding.h             \n
 * Section: mVolumeThresholding                 \n
 * Date:    2004/08/19                          \n
 *
 * $Id: mdsVolumeThresholding.h 64 2006-08-11 08:45:24Z spanel $
 *
 * File description:
 * - Simple voxel value thresholding.
 */

#ifndef MDS_VOLUMETHRESHOLDING_H
#define MDS_VOLUMETHRESHOLDING_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module providing a simple voxel value thresholding.
 */
class CVolumeThresholding : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    MDS_CLASS_NAME(CVolumeThresholding);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CVolumeThresholding);

public:
    //! Default constructor.
    CVolumeThresholding(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CVolumeThresholding();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing a usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);

protected:
    //! Module command line arguments values.
    unsigned int m_uMin, m_uMax;
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CVolumeThresholding::tSmartPtr  CVolumeThresholdingPtr;


#endif // MDS_VOLUMETHRESHOLDING_H

