//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsSegMethod.cpp                    \n
 * Section: mVolumeSeg                          \n
 * Date:    2005/01/25                          \n
 *
 * $Id: mdsSegMethod.cpp 64 2006-08-11 08:45:24Z spanel $
 *
 * File description:
 * - Sample implementation of a volume segmentation method.
 */

#include "mdsSegMethod.h"


namespace mds
{
namespace seg
{

//==============================================================================
/*
 * Implementation of the mds::CSegMethod.
 */

// Segmentation method initialization
bool CSegMethod::init()
{
    return true;
}


// Image segmentation method
bool CSegMethod::operator()(const CSegMethod::tVolume *pSrcVolume,
                            CSegMethod::tVolume *pDstVolume
                            )
{
    MDS_CHECK(pSrcVolume && pDstVolume, return false);

    return true;
}


} // namespace seg
} // namespace mds

