//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVolumeRange.h                    \n
 * Section: mVolumeRange                        \n
 * Date:    2004/08/10                          \n
 *
 * $Id: mdsVolumeRange.h 61 2006-08-10 14:03:53Z spanel $
 *
 * File description:
 * - Extends a given voxel value interval to the range 0..MAX.
 */

#ifndef MDS_VOLUMERANGE_H
#define MDS_VOLUMERANGE_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module extends a given voxel value interval to the range 0..MAX.
 */
class CVolumeRange : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    MDS_CLASS_NAME(CVolumeRange);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CVolumeRange);

public:
    //! Default constructor.
    CVolumeRange(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CVolumeRange();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing a usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);

protected:
    //! Module parameters.
    bool m_bAuto;
    unsigned int m_uMin, m_uMax, m_uMAX;
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CVolumeRange::tSmartPtr     CVolumeRangePtr;


#endif // MDS_VOLUMERANGE_H

