//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVolumeInfo.h                     \n
 * Section: mVolumeInfo                         \n
 * Date:    2004/08/10                          \n
 *
 * $Id: mdsVolumeInfo.h 64 2006-08-11 08:45:24Z spanel $
 *
 * File description:
 * - Shows information on input volume.
 */

#ifndef MDS_VOLUMEINFO_H
#define MDS_VOLUMEINFO_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module reads an input volume and prints several information on it.
 */
class CVolumeInfo : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    MDS_CLASS_NAME(CVolumeInfo);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CVolumeInfo);

public:
    //! Default constructor.
    CVolumeInfo(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CVolumeInfo();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing a usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CVolumeInfo::tSmartPtr  CVolumeInfoPtr;


#endif // MDS_VOLUMEINFO_H

