//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVolumeHistogram.h                \n
 * Section: mVolumeHistogram                    \n
 * Date:    2005/02/11                          \n
 *
 * $Id: mdsVolumeHistogram.h 64 2006-08-11 08:45:24Z spanel $
 * 
 * Description:
 * - Shows volume histogram.
 */

#ifndef MDS_VLMHISTOGRAM_H
#define MDS_VLMHISTOGRAM_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module extends a given voxel value interval to the range 0..MAX.
 */
class CVolumeHistogram : public mds::mod::CModule
{
public:
    //! Standard method getClassName().
    MDS_CLASS_NAME(CVolumeHistogram);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CVolumeHistogram);

public:
    //! Default constructor.
    CVolumeHistogram(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CVolumeHistogram();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing a usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);

protected:
    //! Module parameters.
    int m_iBins;
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CVolumeHistogram::tSmartPtr     CVolumeHistogramPtr;


#endif // MDS_VLMHISTOGRAM_H

