//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVolumeEdgeDetector.h             \n
 * Section: mVolumeEdgeDetector                 \n
 * Date:    2006/04/27                          \n
 *
 * $Id: mdsVolumeEdgeDetector.h 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Advanced volume edge detection algorithms.
 */

#ifndef MDS_DENSITYVOLUMEEDGEDETECTOR_H
#define MDS_DENSITYVOLUMEEDGEDETECTOR_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module providing several convolution image filtering functions.
 */
class CVolumeEdgeDetector : public mds::mod::CModule
{
public:
    //! Standard method getClassName()
    MDS_CLASS_NAME(CVolumeEdgeDetector);

    //! Smart pointer type
    //! - Declares type tSmartPtr
    MDS_SHAREDPTR(CVolumeEdgeDetector);

public:
    //! Default constructor
    CVolumeEdgeDetector(const std::string& sDescription);

    //! Virtual destructor
    virtual ~CVolumeEdgeDetector();

protected:
    //! Virtual method called on startup
    virtual bool startup();

    //! Virtual method called by the processing thread
    virtual bool main();

    //! Called on console shutdown
    virtual void shutdown();

    //! Called on writing a usage statement
    virtual void writeExtendedUsage(std::ostream& Stream);

protected:
    //! Value of the edge detector type argument.
    std::string m_ssDetectorName;

    //! Type specific arguments.
    double m_dSigma, m_dT1, m_dT2, m_dT;
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CVolumeEdgeDetector::tSmartPtr  CVolumeEdgeDetectorPtr;


#endif // MDS_DENSITYVOLUMEEDGEDETECTOR_H

