//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2004 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsSliceThresholding.h              \n
 * Section: mSliceThresholding                  \n
 * Date:    2004/08/19                          \n
 *
 * $Id: mdsSliceThresholding.h 64 2006-08-11 08:45:24Z spanel $
 *
 * File description:
 * - Simple pixel value thresholding.
 */

#ifndef MDS_SLICETHRESHOLDING_H
#define MDS_SLICETHRESHOLDING_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module used for a simple pixel values tresholding.
 */
class CSliceThresholding : public mds::mod::CModule
{
public:
    //! Standard method getClassName()
    MDS_CLASS_NAME(CSliceThresholding);

    //! Smart pointer type
    //! - Declares type tSmartPtr
    MDS_SHAREDPTR(CSliceThresholding);

public:
    //! Default constructor
    CSliceThresholding(const std::string& sDescription);

    //! Virtual destructor
    virtual ~CSliceThresholding();

protected:
    //! Virtual method called on startup
    virtual bool startup();

    //! Virtual method called by the processing thread
    virtual bool main();

    //! Called on console shutdown
    virtual void shutdown();

    //! Called on writing a usage statement
    virtual void writeExtendedUsage(std::ostream& Stream);

protected:
    //! Module command line arguments values
    unsigned int m_uMin, m_uMax;
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CSliceThresholding::tSmartPtr   CSliceThresholdingPtr;


#endif // MDS_SLICETHRESHOLDING_H

