//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsSliceInfo.h                      \n
 * Section: mSliceInfo                          \n
 * Date:    2003/12/22                          \n
 *
 * $Id: mdsSliceInfo.h 64 2006-08-11 08:45:24Z spanel $
 *
 * File description:
 * - Shows information on input slice.
 */

#ifndef MDS_SLICEINFO_H
#define MDS_SLICEINFO_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module reads an input slice and prints several information on it.
 */
class CSliceInfo : public mds::mod::CModule
{
public:
    //! Standard method getClassName()
    MDS_CLASS_NAME(CSliceInfo);

    //! Smart pointer type
    //! - Declares type tSmartPtr
    MDS_SHAREDPTR(CSliceInfo);

public:
    //! Default constructor
    CSliceInfo(const std::string& sDescription);

    //! Virtual destructor
    virtual ~CSliceInfo();

protected:
    //! Virtual method called on startup
    virtual bool startup();

    //! Virtual method called by the processing thread
    virtual bool main();

    //! Called on console shutdown
    virtual void shutdown();

    //! Called on writing a usage statement
    virtual void writeExtendedUsage(std::ostream& Stream);
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CSliceInfo::tSmartPtr   CSliceInfoPtr;


#endif // MDS_SLICEINFO_H

