//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2004 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsLoadJPEG.h                       \n
 * Section: mLoadJPEG                           \n
 * Date:    2004/03/31                          \n
 *
 * $Id: mdsLoadJPEG.h 358 2007-06-13 11:08:43Z spanel $
 *
 * File description:
 * - Reads JPEG image from an input channel.
 * - Converts it to the slice format.
 */

#ifndef MDS_LOADJPEG_H
#define MDS_LOADJPEG_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsModule.h>


//==============================================================================
/*!
 * Module that loads PNG image data and converts it to mds::img::CSlice.
 */
class CLoadJPEG : public mds::mod::CModule
{
public:
    //! Standard method getClassName()
    MDS_CLASS_NAME(CLoadJPEG);

    //! Smart pointer type
    //! - Declares type tSmartPtr
    MDS_SHAREDPTR(CLoadJPEG);

public:
    //! Default constructor
    CLoadJPEG(const std::string& sDescription);

    //! Virtual destructor
    virtual ~CLoadJPEG();

protected:
    //! Virtual method called on startup
    virtual bool startup();

    //! Virtual method called by the processing thread
    virtual bool main();

    //! Called on console shutdown
    virtual void shutdown();

    //! Called on writing a usage statement
    virtual void writeExtendedUsage(std::ostream& Stream);

protected:
    //! Value of the image format argument.
    std::string m_ssFormat;
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CLoadJPEG::tSmartPtr    CLoadJPEGPtr;


#endif // MDS_LOADJPEG_H

