//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsCreateSHM.h                      \n
 * Section: mCreateSHM                          \n
 * Date:    2006/04/07                          \n
 *
 * $Id: mdsCreateSHM.h 64 2006-08-11 08:45:24Z spanel $
 *
 * File description:
 * - Console utility allocates a new shared memory block.
 * - Only for testing!
 */

#ifndef MDS_CREATESHM_H
#define MDS_CREATESHM_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsConsole.h>
#include <MDSTk/System/mdsSharedMem.h>
#include <MDSTk/System/mdsSemaphore.h>


//==============================================================================
/*!
 * Console utility which allocates a shared memory block.
 * - Only for testing!
 */
class CCreateSHM : public mds::mod::CConsole
{
public:
    //! Standard method getClassName().
    MDS_CLASS_NAME(CCreateSHM);

    //! Smart pointer type.
    //! - Declares type tSmartPtr.
    MDS_SHAREDPTR(CCreateSHM);

public:
    //! Default constructor.
    CCreateSHM(const std::string& sDescription);

    //! Virtual destructor.
    virtual ~CCreateSHM();

protected:
    //! Virtual method called on startup.
    virtual bool startup();

    //! Virtual method called by the processing thread.
    virtual bool main();

    //! Called on console shutdown.
    virtual void shutdown();

    //! Called on writing a usage statement.
    virtual void writeExtendedUsage(std::ostream& Stream);

protected:
    //! Module parameters.
    std::string m_ssName;
    int m_iSize;

    //! Pointer to the shared memory
    mds::sys::CSemaphore *m_pSemaphore;

    //! Pointer to the shared memory
    mds::sys::CSharedMem *m_pSharedMem;
};


//==============================================================================
/*!
 * Smart pointer to console application.
 */
typedef CCreateSHM::tSmartPtr   CCreateSHMPtr;


#endif // MDS_CREATESHM_H

