////////////////////////////////////////////////////////////
// $Id: mcvertices.cpp 383 2007-06-21 12:17:06Z spanel $
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// include soubory

#include <VectorEntity/mcvertices.h>

using namespace vctl;

////////////////////////////////////////////////////////////
//

void MCVerticeS::serialize(mds::mod::CChannelSerializer& Writer)
{
  // Begin of data serialization block
  MDS_DE_SERIALIZE_BEGIN;

    int               index = 0;                 // vertex index
    MCVertex          * aktual = GetFirst();     // actual entity pointer

    // write entity number into channel
    Writer.writeInt(MCList<MCVertex>::list_node_number);

    // entity cycle
    while(aktual != NULL)
    {
      // save actual entity
      aktual->SerializeEntity(Writer);
      // set vertex index
      aktual->SetIndex(index);
      // vertex index incrementation
      index++;
      // get next actual entity pointer
      aktual = aktual->GetNext();
    }

  // End of the block
  MDS_DE_SERIALIZE_END;
}

////////////////////////////////////////////////////////////
//

void MCVerticeS::deserialize(mds::mod::CChannelSerializer& Reader)
{
  // clear container from existing entities
  ClearAll();

  // Begin of data deserialization block
  MDS_DE_DESERIALIZE_BEGIN;

    int                   pocet;                    // entity number
    MCVertex              work_vertex;              // local working instance of vertex

    // read entity number from channel
    Reader.readInt(pocet);
    if( Reader.isError() )
      return;

    // entity cycle
    for (int i = 0; i < pocet; i++)
    {
      // read new entity
      work_vertex.DeserializeEntity(Reader);
      if( Reader.isError() )
        return;
      
      // including read edge into container structures
      MCVertex *new_vertex = New(work_vertex);
      assert(new_vertex);
      new_vertex->SetEntityAttributes(&work_vertex);
    }

  // End of the block
  MDS_DE_DESERIALIZE_END;
}

////////////////////////////////////////////////////////////
//

MCVertex * MCVerticeS::New( MCPoint3D & new_bod )
{
    MCVertex          * new_node;


    // vetveni podle provadeni testovani existence vrcholu
    if (test_existence)       // provadi se testovani existence
    {
        // nastaveni parametru vytvareneho uzlu do pracovniho uzlu
        work_node.SetPoint3D(new_bod);
        // vypocet hash kodu pro souradnice noveho bodu
        work_node.MakeHashCode();

        // test existence pracovniho uzlu
        if ((new_node = TestExistence(&work_node)) == NULL)
        {
            // vytvoreni noveho objektu uzlu
            new_node = new MCVertex(work_node);
            // ulozeni hash kodu pracovniho vrcholu
            new_node->SetHashCode(work_node);
            // vlozeni noveho uzlu do retezu
            AddNode(new_node);
            // vlozeni noveho uzlu do fronty existence
            exist_fronta.Sort(new_node->GetHashCode(), new_node);
        }
    }
    else                      // neprovadi se testovani existence
    {
        // vytvoreni noveho objektu uzlu
        new_node = new MCVertex(new_bod);
        // vlozeni noveho uzlu do retezu
        AddNode(new_node);
    }

    return new_node;
}

////////////////////////////////////////////////////////////
//

MCVertex * MCVerticeS::New( double new_x, double new_y, double new_z )
{
    MCVertex          * new_node;


    // vetveni podle provadeni testovani existence vrcholu
    if (test_existence)       // provadi se testovani existence
    {
        // nastaveni parametru vytvareneho uzlu do pracovniho uzlu
        work_node.SetXYZ(new_x, new_y, new_z);
        // vypocet hash kodu pro souradnice noveho bodu
        work_node.MakeHashCode();

        // test existence pracovniho uzlu
        if ((new_node = TestExistence(&work_node)) == NULL)
        {
            // vytvoreni noveho objektu uzlu
            new_node = new MCVertex(new_x, new_y, new_z);
            // ulozeni hash kodu pracovniho vrcholu
            new_node->SetHashCode(work_node);
            // vlozeni noveho uzlu do retezu
            AddNode(new_node);
            // vlozeni noveho uzlu do fronty existence
            exist_fronta.Sort(new_node->GetHashCode(), new_node);
        }
    }
    else                      // neprovadi se testovani existence
    {
        // vytvoreni noveho objektu uzlu
        new_node = new MCVertex(new_x, new_y, new_z);
        // vlozeni noveho uzlu do retezu
        AddNode(new_node);
    }

    return new_node;
}

////////////////////////////////////////////////////////////
//

//MCVertex * MCVerticeS::New( double & new_x, double & new_y, double & new_z )
//{
//    MCVertex          * new_node;
//
//
//    // vetveni podle provadeni testovani existence vrcholu
//    if (test_existence)       // provadi se testovani existence
//    {
//        // nastaveni parametru vytvareneho uzlu do pracovniho uzlu
//        work_node.SetXYZ(new_x, new_y, new_z);
//        // vypocet hash kodu pro souradnice noveho bodu
//        work_node.MakeHashCode();
//
//        // test existence pracovniho uzlu
//        if ((new_node = TestExistence(&work_node)) == NULL)
//        {
//            // vytvoreni noveho objektu uzlu
//            new_node = new MCVertex(new_x, new_y, new_z);
//            // ulozeni hash kodu pracovniho vrcholu
//            new_node->SetHashCode(work_node);
//            // vlozeni noveho uzlu do retezu
//            AddNode(new_node);
//            // vlozeni noveho uzlu do fronty existence
//            exist_fronta.Sort(new_node->GetHashCode(), new_node);
//        }
//    }
//    else                      // neprovadi se testovani existence
//    {
//        // vytvoreni noveho objektu uzlu
//        new_node = new MCVertex(new_x, new_y, new_z);
//        // vlozeni noveho uzlu do retezu
//        AddNode(new_node);
//    }
//
//    return new_node;
//}

////////////////////////////////////////////////////////////
//

MCVertex * MCVerticeS::NewFromWorkNode()
{
    MCVertex          * new_node;


    // vetveni podle provadeni testovani existence vrcholu
    if (test_existence)       // provadi se testovani existence
    {
        // vypocet hash kodu pro souradnice noveho bodu
        work_node.MakeHashCode();

        // test existence pracovniho uzlu
        if ((new_node = TestExistence(&work_node)) == NULL)
        {
            // vytvoreni noveho objektu uzlu
            new_node = new MCVertex(work_node);
            // ulozeni hash kodu pracovniho vrcholu
            new_node->SetHashCode(work_node);
            // vlozeni noveho uzlu do retezu
            AddNode(new_node);
            // vlozeni noveho uzlu do fronty existence
            exist_fronta.Sort(new_node->GetHashCode(), new_node);
        }
    }
    else                      // neprovadi se testovani existence
    {
        // vytvoreni noveho objektu uzlu
        new_node = new MCVertex(work_node);
        // vlozeni noveho uzlu do retezu
        AddNode(new_node);
    }

    return new_node;
}

////////////////////////////////////////////////////////////
//

void MCVerticeS::Erase( MCVertex * del_ent)
{
    assert(del_ent != NULL);

    // zruseni node z exist fronty
    exist_fronta.UnSort(del_ent->GetHashCode(), del_ent);

    // zruseni node z retezu
    EraseNode(del_ent);

    // uvolneni pameti pro objekt node
    delete(del_ent);
}

////////////////////////////////////////////////////////////
//

void MCVerticeS::RegenExistence(  )
{
    MCVertex        * aktual = GetFirst();


    // nulobani exist fronty
    exist_fronta.Clear();

    // cyklus entit retezce
    while(aktual != NULL)
    {
        // vypocet hash kodu pro souradnice aktualniho vrcholu
        aktual->MakeHashCode();
        // zatrideni aktualniho node do exist fronty
        exist_fronta.Sort(aktual->GetHashCode(), aktual);
        // ziskani nasledujici entity
        aktual = aktual->GetNext();
    }
}

////////////////////////////////////////////////////////////
//

void MCVerticeS::MakeIndexVector( std::vector<MCVertex *> & pole_node )
{
    int           index = 0;                               // poradove cislo uzlu
    MCVertex      * aktual = GetFirst();                   // ukazatel na aktualni uzel


    // rezervace velikosti vektoru pro node
    pole_node.resize(GetNumber());

    // cyklus entit retezce
    while(aktual != NULL)
    {
        // ulozeni ukazatele na aktual na pozici v poli podle indexu
        pole_node[index] = aktual;
        // inkrementace indexu
        index++;
        // ziskani nasledujici entity
        aktual = aktual->GetNext();
    }
}

////////////////////////////////////////////////////////////
//

void MCVerticeS::Indexing()
{
    int         index = 0;                 // poradove cislo uzlu
    MCVertex    * aktual = GetFirst();     // ukazatel na aktualni uzel`


    // cyklus entit retezce
    while(aktual != NULL)
    {
        // nastaveni cisla node
        aktual->SetIndex(index);
        // inkrementace indexu
        index++;
        // ziskani nasledujici entity
        aktual = aktual->GetNext();
    }
}

////////////////////////////////////////////////////////////
//

void MCVerticeS::GetRange( MCPoint3D & bod_min, MCPoint3D & bod_max )
{
    MCPoint3D      bod;
    MCVertex       * aktual = GetFirst();


    // inicializace max a min hodnot
    bod_min.SetX(1000000000);
    bod_max.SetX(-1000000000);
    bod_min.SetY(1000000000);
    bod_max.SetY(-1000000000);
    bod_min.SetZ(1000000000);
    bod_max.SetZ(-1000000000);

    // cyklus entit retezce
    while(aktual != NULL)
    {
        // ziskani souradnic aktualniho node
        aktual->GetPoint3D(bod);
        // porovnani souradnic s mezemi
        bod_min.SetX( (bod_min.GetX() > aktual->GetX()) ? aktual->GetX() : bod_min.GetX() );
        bod_max.SetX( (bod_max.GetX() < aktual->GetX()) ? aktual->GetX() : bod_max.GetX() );
        bod_min.SetY( (bod_min.GetY() > aktual->GetY()) ? aktual->GetY() : bod_min.GetY() );
        bod_max.SetY( (bod_max.GetY() < aktual->GetY()) ? aktual->GetY() : bod_max.GetY() );
        bod_min.SetZ( (bod_min.GetZ() > aktual->GetZ()) ? aktual->GetZ() : bod_min.GetZ() );
        bod_max.SetZ( (bod_max.GetZ() < aktual->GetZ()) ? aktual->GetZ() : bod_max.GetZ() );
        // ziskani nasledujici entity
        aktual = aktual->GetNext();
    }
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
