////////////////////////////////////////////////////////////
// $Id: mcvertex.cpp 383 2007-06-21 12:17:06Z spanel $
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// include soubory

#include <VectorEntity/mcentity.h>

using namespace vctl;

////////////////////////////////////////////////////////////
//

void MCVertex::DeserializeEntity(mds::mod::CChannelSerializer& Reader)
{
  // loading vertex coordinates
  Reader.readDouble(x);
  Reader.readDouble(y);
  Reader.readDouble(z);

  // deserialize MCEntity data
  MCEntity<MCVertex>::DeserializeEntity(Reader);
}

////////////////////////////////////////////////////////////
//

void MCVertex::SerializeEntity(mds::mod::CChannelSerializer& Writer)
{
  // saving vertex coordinates
  Writer.writeDouble(x);
  Writer.writeDouble(y);
  Writer.writeDouble(z);

  // serialize MCEntity data
  MCEntity<MCVertex>::SerializeEntity(Writer);
}

////////////////////////////////////////////////////////////
//

void MCVertex::GetRegisteredEdgeList(std::vector<MCEdge *> & _edge_list)
{
    MCEdge				* aktual = edge_list;				// ukazatel na aktualni prvek


    // vyprazdneni daneho pole
    _edge_list.clear();

    // cyklus entit registrovanych pro vrchol
    while(aktual != NULL)
    {
        // pridani aktualni hrany do seznamu
        _edge_list.push_back(aktual);
        // ziskani dalsi entity registrovane pro vrchol
        aktual = aktual->GetVertexEdge(this);
    }
}

////////////////////////////////////////////////////////////
//

void MCVertex::GetRegisteredTriList(std::vector<MCTri *> & _tri_list)
{
    MCTri				* aktual = tri_list;					// ukazatel na aktualni prvek


    // vyprazdneni daneho pole
    _tri_list.clear();

    // cyklus entit registrovanych pro vrchol
    while(aktual != NULL)
    {
        // pridani aktualniho tri do seznamu
        _tri_list.push_back(aktual);
        // ziskani dalsi entity registrovane pro vrchol
        aktual = aktual->GetVertexTri(this);
    }
}

////////////////////////////////////////////////////////////
//

void MCVertex::GetRegisteredTetraList(std::vector<MCTetra *> & _tetra_list)
{
    MCTetra				* aktual = tetra_list;				// ukazatel na aktualni prvek


    // vyprazdneni daneho pole
    _tetra_list.clear();

    // cyklus entit registrovanych pro vrchol
    while(aktual != NULL)
    {
        // pridani aktualniho tetra do seznamu
        _tetra_list.push_back(aktual);
        // ziskani dalsi entity registrovane pro vrchol
        aktual = aktual->GetVertexTetra(this);
    }
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
