////////////////////////////////////////////////////////////
// $Id: mctris.cpp 383 2007-06-21 12:17:06Z spanel $
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// include soubory

#include <VectorEntity/mctris.h>
#include <VectorEntity/mcsphere.h>

#include <time.h>

using namespace vctl;

////////////////////////////////////////////////////////////
// telo tridy

////////////////////////////////////////////////////////////
//

void MCTriS::serialize(mds::mod::CChannelSerializer& Writer)
{
  // serialize vertices of the mesh in to given channel
  vertices->serialize(Writer);

  // Begin of data serialization block
  MDS_DE_SERIALIZE_BEGIN;

    MCTri             * aktual = GetFirst();        // actual entity pointer

    // write entity number into channel
    Writer.writeInt(MCList<MCTri>::list_node_number);

    // entity cycle
    while(aktual != NULL)
    {
      // save actual entity
      aktual->SerializeEntity(Writer);

      // get next actual entity pointer
      aktual = aktual->GetNext();
    }

  // End of the block
  MDS_DE_SERIALIZE_END;
}

////////////////////////////////////////////////////////////
//

void MCTriS::deserialize(mds::mod::CChannelSerializer& Reader)
{
  // clear container from existing entities
  ClearAll();

  // deserialize vertices of the mesh in to given channel
  vertices->deserialize(Reader);
  if( Reader.isError() )
    return;

  std::vector<MCVertex *>    index_array;                     // triangles vertices pointer array

  // make triangles vertices pointer array
  vertices->MakeIndexVector(index_array);

  // Begin of data deserialization block
  MDS_DE_DESERIALIZE_BEGIN;

    int                   pocet;                    // entity number
    MCTri                 work_tri;                 // local working instance of triangle

    // read entity number from channel
    Reader.readInt(pocet);
    if( Reader.isError() )
      return;

    // entity cycle
    for (int i = 0; i < pocet; i++)
    {
      // read new entity
      work_tri.DeserializeEntity(Reader, index_array);
      if( Reader.isError() )
        return;
      
      // including read tri into container structures
      MCTri *new_tri = New(work_tri.GetVertex(0), work_tri.GetVertex(1), work_tri.GetVertex(2));
      assert(new_tri);
      new_tri->SetEntityAttributes(&work_tri);
    }

  // End of the block
  MDS_DE_DESERIALIZE_END;
}

////////////////////////////////////////////////////////////
//

MCTri * MCTriS::New(MCVertex * _u0, MCVertex * _u1, MCVertex * _u2)
{
    MCTri          * new_tri;          // ukazatel na nove tri

    assert((_u0 != NULL) && (_u1 != NULL) && (_u2 != NULL));

    // test existence tri danych uzlu
    if ((new_tri = TestExistence(_u0, _u1, _u2)) == NULL)
    {
        // vytvoreni noveho objektu tri
        new_tri = new MCTri(_u0, _u1, _u2);
        // vlozeni noveho tri do retezu
        AddNode(new_tri);
        // registrace noveho tri u jejich uzlu
        new_tri->Registration();
    }

    return new_tri;
}

////////////////////////////////////////////////////////////
//

void MCTriS::Erase( MCTri * del_ent)
{
    assert(del_ent != NULL);

    // vyhozeni entity z retezce
    EraseNode(del_ent);

    // uvolneni vazeb entity u jejich node
    del_ent->DeRegistration();

    // zruseni objektu dane entity
    delete(del_ent);
}

////////////////////////////////////////////////////////////
//

void MCTriS::DeRegistrationAll()
{
    MCTri        * actual = GetFirst();      // ukazatel na aktualni entitu


    // zruseni vsech existujicich entit s uvolnovanim vazeb
    while (actual != NULL)
    {
        // odregistrovani aktualniho Tri z jeho vrcholu
        actual->DeRegistration();
        // ziskani nasledujici entity
        actual = actual->GetNext();
    }
}

////////////////////////////////////////////////////////////
//

void MCTriS::GetTriEdge( MCVertex * _u0, MCVertex * _u1, std::vector<MCTri *> & tri_pole )
{
    assert((_u0 != NULL) && (_u1 != NULL));

    MCTri      * actual = _u0->GetRegisteredTri();            // ukazatel na aktualni tri kolem prvniho uzlu hrany

    // vyprazdneni pole pro tri
    tri_pole.clear();

    // cyklus tri kolem prvniho uzlu dane hrany
    while (actual != NULL)
    {
        // test aktual, jestli obsahuje druhy uzel hrany
        if (actual->IsVertexBool(_u1))
            tri_pole.push_back(actual);      // pridani aktual do fronty tri

        // ziskani dalsiho tri podilejiciho se na prvnim uzlu dane hrany
        actual = actual->GetVertexTri(_u0);
    }
}

////////////////////////////////////////////////////////////
//

int MCTriS::GetTriEdgeNumber( MCVertex * _u0, MCVertex * _u1)
{
    assert((_u0 != NULL) && (_u1 != NULL));

    MCTri      * actual = _u0->GetRegisteredTri();            // ukazatel na aktualni tri kolem prvniho uzlu hrany
    int        poc_tri = 0;                              // pocet tri hrany

    // cyklus tri kolem prvniho uzlu dane hrany
    while (actual != NULL)
    {
        // test aktual, jestli obsahuje druhy uzel hrany
        if (actual->IsVertexBool(_u1))
            poc_tri++;

        // ziskani dalsiho tri podilejiciho se na prvnim uzlu dane hrany
        actual = actual->GetVertexTri(_u0);
    }

    return poc_tri;
}

////////////////////////////////////////////////////////////
//

bool MCTriS::TestEdgeExistence( MCVertex * _u0, MCVertex * _u1 )
{
    assert((_u0 != NULL) && (_u1 != NULL));

    MCTri      * actual = _u0->GetRegisteredTri();            // ukazatel na tri zdilejici prvni uzel hrany

    // cyklus tri kolem prvniho uzlu dane hrany
    while (actual != NULL)
    {
        // test jestli aktualni tri obsahuje druhy uzel hrany
        if (actual->IsVertexBool(_u1))
            return true;                // hrana existuje

        // ziskani dalsiho tri podilejiciho se na prvnim uzlu dane hrany
        actual = actual->GetVertexTri(_u0);
    }

    // hrana neexistuje
    return false;
}

////////////////////////////////////////////////////////////
//

MCTri * MCTriS::TestExistence(MCVertex * _u0, MCVertex * _u1, MCVertex * _u2)
{
    assert((_u0 != NULL) && (_u1 != NULL) && (_u2 != NULL));

    MCTri      * actual = _u0->GetRegisteredTri();            // ukazatel na tri zdilejici prvni uzel hrany

    // cyklus tri kolem prvniho uzlu dane hrany
    while (actual != NULL)
    {
        // test jestli aktualni tri obsahuje druhy a treti uzel daneho tri
        if (actual->IsVertexBool(_u1) && actual->IsVertexBool(_u2))
            return actual;                // tri existuje

        // ziskani dalsiho tri podilejiciho se na prvnim uzlu dane hrany
        actual = actual->GetVertexTri(_u0);
    }

    // tri neexistuje
    return NULL;
}

////////////////////////////////////////////////////////////
//

bool MCTriS::TestManifold()
{
    MCTri        * actual = GetFirst();          // ukazatel na aktualni tri


    // cyklus tri
    while (actual != NULL)
    {
        // testy pocty tri kolem hran aktualniho tri
        if (GetTriEdgeNumber(actual->GetVertex(0), actual->GetVertex(1)) != 2)
            return false;
        if (GetTriEdgeNumber(actual->GetVertex(1), actual->GetVertex(2)) != 2)
            return false;
        if (GetTriEdgeNumber(actual->GetVertex(2), actual->GetVertex(0)) != 2)
            return false;

        // ziskani dalsi tri v poradi
        actual = actual->GetNext();
    }

    return true;
}

////////////////////////////////////////////////////////////
//

void MCTriS::MakeAllTrisEdges()
{
    MCTri									* actual = GetFirst();					        // ukazatel na aktualni tri site


    // cyklus tri site
    while (actual != NULL)
    {
        // vytvoreni hran aktualniho tri
        MakeTriEdges(actual);
        // ziskani nasledujiciho tri retezce
        actual = actual->GetNext();
    }
}

////////////////////////////////////////////////////////////
//

void MCTriS::MakeTriEdges(MCTri * _tri)
{
    // test existence daneho tri
    assert(_tri != NULL);

    // vytvoreni hran daneho tri
    edges.New(_tri->GetVertex(0), _tri->GetVertex(1));
    edges.New(_tri->GetVertex(1), _tri->GetVertex(2));
    edges.New(_tri->GetVertex(2), _tri->GetVertex(0));
}

////////////////////////////////////////////////////////////
//

void MCTriS::EraseEdgesNoTris()
{
    MCEdge					* actual = edges.GetFirst();					        // ukazatel na aktualni hranu site
    MCEdge          * to_erase;                                   // ukazatel na hranu urcenou k vymazani


    // cyklus hran site
    while (actual != NULL)
    {
        // ziskani a test poctu tri aktualni hrany
        if (GetTriEdgeNumber(actual->GetVertex(0), actual->GetVertex(1)) == 0)
        {
            // ulozeni ukazatel na hranu urcenou k vymazani
            to_erase = actual;
            // ziskani nasledujici hrany retezce
            actual = actual->GetNext();
            // vymazani hrany retezce, ktera nezdili zadne tri
            edges.Erase(to_erase);
        }
        else
            // ziskani nasledujici hrany retezce
            actual = actual->GetNext();
    }
}

////////////////////////////////////////////////////////////
//

bool MCTriS::LoadSTL(mds::mod::CChannel& Channel)
{
    char                file_heared[90];               // STL file header array
    unsigned int        file_tri_number;               // Number of tris saved in STL file
    unsigned short int  file_tri_attribute;            // STL tri attribute saved in file
    float               file_tri_n[3];                 // file tri normal coordinates array
    float               file_tri_v1[3];                // file tri vertex coordinates array
    float               file_tri_v2[3];                // file tri vertex coordinates array
    float               file_tri_v3[3];                // file tri vertex coordinates array
    MCVertex            * v1, * v2, * v3;              // new created vertices pointers


    // given channel testing
    if ( ! Channel.isConnected())
      return false;

    // clear container from existing entities
    ClearAll();

    // file header loading
    if (Channel.read( (char *) file_heared, 80) != 80)
      return false;

    // file tri number loading
    if (Channel.read( (char *) &file_tri_number, sizeof(file_tri_number)) != sizeof(file_tri_number))
      return false;

    // vertex existence switch on
    assert(vertices != NULL);
    vertices->SetTestExistence(true);

    // file tris reading cycle
    for (unsigned int t = 0; t < file_tri_number; ++t)
    {
      // file tri normal loading
      if (Channel.read( (char *) file_tri_n, (sizeof(float)*3)) != (sizeof(float)*3))
      {
        vertices->SetTestExistence(false);
        return false;
      }
      // file tri vertex v1 loading
      if (Channel.read( (char *) file_tri_v1, (sizeof(float)*3)) != (sizeof(float)*3))
      {
        vertices->SetTestExistence(false);
        return false;
      }
      // file tri vertex v2 loading
      if (Channel.read( (char *) file_tri_v2, (sizeof(float)*3)) != (sizeof(float)*3))
      {
        vertices->SetTestExistence(false);
        return false;
      }
      // file tri vertex v3 loading
      if (Channel.read( (char *) file_tri_v3, (sizeof(float)*3)) != (sizeof(float)*3))
      {
        vertices->SetTestExistence(false);
        return false;
      }
      // file tri attribute loading
      if (Channel.read( (char *) &file_tri_attribute, sizeof(file_tri_attribute)) != sizeof(file_tri_attribute))
      {
        vertices->SetTestExistence(false);
        return false;
      }

      // create new vertices by loaded coordinates
      v1 = vertices->New(file_tri_v1[0], file_tri_v1[1], file_tri_v1[2]);
      v2 = vertices->New(file_tri_v2[0], file_tri_v2[1], file_tri_v2[2]);
      v3 = vertices->New(file_tri_v3[0], file_tri_v3[1], file_tri_v3[2]);
      assert((v1 != NULL) && (v2 != NULL) && (v3 != NULL));
      // create new tri by loaded coordinates
      New(v1, v2, v3);
    }

    // tri number control
    //assert(GetNumber() == file_tri_number);

    // vertex existence switch off
    vertices->SetTestExistence(false);

    return true;
}

////////////////////////////////////////////////////////////
//

bool MCTriS::SaveSTL(mds::mod::CChannel& Channel)
{
    char                file_heared[90];               // STL file header array
    unsigned int        file_tri_number;               // Number of tris saved in STL file
    unsigned short int  file_tri_attribute = 0;        // STL tri attribute saved in file
    MCTri               * actual = GetFirst();         // actual tri pointer
    MCVertex            * tri_vertices[3];             // atual tri vertices array
    MCVector3D          actual_tri_n;                  // actual tri normal
    float               actual_coordinates[3];         // actual coordinates of vector or vertex


    // given channel testing
    if ( ! Channel.isConnected())
      return false;

    // initialize file header
    memset(file_heared, 0, 85);
    // set file header text
    strcpy(file_heared, "Binary STL file created by conversion of TRI file format, MDSTk::VectEntity library");
    // write file header
    if ( ! Channel.write( (char *) file_heared, 80) )
      return false;

    // write file tri number
    file_tri_number = GetNumber();
    if ( ! Channel.write( (char *) &file_tri_number, sizeof(unsigned int)) )
      return false;

    // file tris writing cycle
    while (actual != NULL)
    {
        // take vertices of actual tri
        actual->GetVerticeS(tri_vertices);

        // take actual tri normal
        actual_tri_n = actual->GetNormal();
        actual_coordinates[0] = (float) actual_tri_n.GetX();
        actual_coordinates[1] = (float) actual_tri_n.GetY();
        actual_coordinates[2] = (float) actual_tri_n.GetZ();
        // write actual tri normal coordinates
        if ( ! Channel.write( (char *) actual_coordinates, sizeof(float)*3))
          return false;

        // actual tri vertices cycle
        for (int i = 0; i < 3; i++)
        {
            // take actual tri vertex coordinates
            actual_coordinates[0] = (float) tri_vertices[i]->GetX();
            actual_coordinates[1] = (float) tri_vertices[i]->GetY();
            actual_coordinates[2] = (float) tri_vertices[i]->GetZ();
            // write actual tri vertex coordinates
            if ( ! Channel.write( (char *) actual_coordinates, sizeof(float)*3))
              return false;
        }

        // write tri STL atribute
        if ( ! Channel.write( (char *) &file_tri_attribute, sizeof(unsigned short int)))
          return false;

        // take next actual tri pointer
        actual = actual->GetNext();
    }

    return true;
}

////////////////////////////////////////////////////////////
//

void MCTriS::SaveVRML(std::string & jm_soubor)
{
    time_t              cas;                                                    // hodnota aktualniho casu
    int                 index = 0;                                              // index uzlu site
    MCVertex            * actual_node = GetVerticeS()->GetFirst();              // ukazatel na aktualni uzel site
    MCTri               * actual_tri = GetFirst();                              // ukazatel na aktualni tri site
    std::ofstream       proud(jm_soubor.c_str());                               // proud pro ulozeni dat site


    // test existence a otevreni proudu
    if ( ! proud.is_open() )
        throw std::runtime_error("Chyba otevreni proudu pro zapis MCTriS do STL, SaveSTL");

    // ziskani aktualni casu
    time(&cas);

    // zapsani hlavicky vrml souboru
    proud << "#VRML V2.0 utf8" << std::endl << std::endl;
    proud << "# Create by Premysl Krsek, conversion of TRI file by VectEntity library." << std::endl;
    proud << "# Date: " << ctime(&cas) << std::endl << std::endl;

    // zapis casti Transformace do vrml souboru
    proud << "Transform {" << std::endl << "children [" << std::endl;
    // zapis tvaru
    proud << "Shape {" << std::endl;
    // zapis materialovych vlastnosti
    proud << "appearance Appearance { material Material { diffuseColor 0.9882 0.9882 0.9882 } }" << std::endl;
    // zapis geometrie
    proud << "geometry IndexedFaceSet {" << std::endl;

    // zapis parametru site
    proud << "ccw TRUE" << std::endl << "solid TRUE" << std::endl << "creaseAngle 1.5708" << std::endl;

    // zapsani bodu site
    proud << "coord Coordinate { point [" << std::endl;
    // cyklus uzlu site pro jejich ulozeni do VRML
    while(actual_node != NULL)
    {
        // nastaveni cislo aktualniho node
        actual_node->SetIndex(index);
        // zapsani souradnic aktualniho node do souboru
        proud << actual_node->GetX() << " " << actual_node->GetY() << " " << actual_node->GetZ() << "," << std::endl;
        // ziskani nasledujiciho node
        actual_node = actual_node->GetNext();
        // prirustek indexu uzlu
        index++;
    }
    // uzavreni casti bodu site
    proud << "] }" << std::endl;

    // zapsani tri site
    proud << "coordIndex [" << std::endl;
    // cyklus tri site pro jejich ulozeni do VRML
    while(actual_tri != NULL)
    {
        // zapsani indexu node aktualniho tri do souboru
        proud << actual_tri->GetVertex(0)->GetIndex() << ", " << actual_tri->GetVertex(1)->GetIndex() << ", " << actual_tri->GetVertex(2)->GetIndex() << ", -1," << std::endl;
        // ziskani nasledujiciho tri
        actual_tri = actual_tri->GetNext();
    }
    // uzavreni casti tri site
    proud << "]" << std::endl;

    // uzavreni casti geometrie
    proud << "}" << std::endl;
    // uzavreni casti tvaru
    proud << "}" << std::endl;
    // uzavreni casti transformace
    proud << "] }" << std::endl;
}

////////////////////////////////////////////////////////////
//

// void MCTriS::
// {
// }

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

