////////////////////////////////////////////////////////////
// $Id: mcedges.cpp 383 2007-06-21 12:17:06Z spanel $
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// include soubory

#include <VectorEntity/mcedges.h>

using namespace vctl;

////////////////////////////////////////////////////////////
// telo tridy

////////////////////////////////////////////////////////////
//

void MCEdgeS::serialize(mds::mod::CChannelSerializer& Writer)
{
  // serialize vertices of the mesh
  vertices.serialize(Writer);

  // Begin of data serialization block
  MDS_DE_SERIALIZE_BEGIN;

    MCEdge            * aktual = GetFirst();       // actual entity pointer

    // write entity number into channel
    Writer.writeInt(MCList<MCEdge>::list_node_number);

    // entity cycle
    while(aktual != NULL)
    {
      // save actual entity
      aktual->SerializeEntity(Writer);
      
      // get next actual entity pointer
      aktual = aktual->GetNext();
    }

  // End of the block
  MDS_DE_SERIALIZE_END;
}

////////////////////////////////////////////////////////////
//

void MCEdgeS::deserialize(mds::mod::CChannelSerializer& Reader)
{
  // clear container from existing entities
  ClearAll();

  // deserialize vertices of the mesh in to given channel
  vertices.deserialize(Reader);
  if( Reader.isError() )
    return;

  std::vector<MCVertex *>    index_array;                     // edges vertices pointer array

  // make edges vertices pointer array
  vertices.MakeIndexVector(index_array);

  // Begin of data deserialization block
  MDS_DE_DESERIALIZE_BEGIN;

    int                   pocet;                    // entity number
    MCEdge                work_edge;                // local working instance of edge

    // read entity number from channel
    Reader.readInt(pocet);
    if( Reader.isError() )
      return;

    // entity cycle
    for (int i = 0; i < pocet; i++)
    {
      // read new entity
      work_edge.DeserializeEntity(Reader, index_array);
      if( Reader.isError() )
        return;
      
      // including read edge into container structures
      MCEdge *new_edge = New(work_edge.GetVertex(0), work_edge.GetVertex(1));
      assert(new_edge);
      new_edge->SetEntityAttributes(&work_edge);
    }

  // End of the block
  MDS_DE_DESERIALIZE_END;
}

////////////////////////////////////////////////////////////
//

MCEdge * MCEdgeS::New( MCVertex * _u0, MCVertex * _u1 )
{
    MCEdge           * new_hrana;          // ukazatel na novou hranu

    assert((_u0 != NULL) && (_u1 != NULL));

    // test existence pracovniho hrany
    if ((new_hrana = TestExistence(_u0, _u1)) == NULL)
    {
        // vytvoreni noveho objektu hrany
        new_hrana = new MCEdge(_u0, _u1);
        // vlozeni nove hrany do retezu
        AddNode(new_hrana);
        // registrace nove hrany u jejich uzlu
        new_hrana->Registration();
    }

    return new_hrana;
}

////////////////////////////////////////////////////////////
//

void MCEdgeS::Erase(MCEdge * del_ent)
{
    assert(del_ent != NULL);

    // vyhozeni entity z retezce
    EraseNode(del_ent);

    // uvolneni vazeb entity u jejich node
    del_ent->DeRegistration();

    // zruseni objektu dane entity
    delete(del_ent);
}

////////////////////////////////////////////////////////////
//

void MCEdgeS::DeRegistrationAll()
{
    MCEdge        * aktual = GetFirst();      // ukazatel na aktualni entitu

    // zruseni vsech existujicich entit s uvolnovanim vazeb
    while (aktual != NULL)
    {
        // odregistrovani aktualniho Edge z jeho vrcholu
        aktual->DeRegistration();
        // ziskani nasledujici entity
        aktual = aktual->GetNext();
    }
}

////////////////////////////////////////////////////////////
//

MCEdge * MCEdgeS::TestExistence(MCVertex * _u0, MCVertex * _u1)
{
    assert((_u0 != NULL) && (_u1 != NULL));

    MCEdge       * aktual = _u0->GetRegisteredEdge();    // ukazatel na hranu zdilejici prvni uzel dane hrany

    // cyklus hran kolem prvniho uzlu dane hrany
    while (aktual != NULL)
    {
        // test jestli aktualni hrana obsahuje druhy uzel dane hrany
        if (aktual->IsVertexBool(_u1))
            return aktual;                // hrana existuje

        // ziskani dalsiho tri podilejiciho se na prvnim uzlu dane hrany
        aktual = aktual->GetVertexEdge(_u0);
    }

    // hrana neexistuje
    return NULL;
}

////////////////////////////////////////////////////////////
//

//void MCEdgeS::()
//{
//}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
