////////////////////////////////////////////////////////////
// $Id: mcedge.cpp 383 2007-06-21 12:17:06Z spanel $
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// include soubory

#include <VectorEntity/mcentity.h>

using namespace vctl;

////////////////////////////////////////////////////////////
//

void MCEdge::DeRegistration()
{
    MCEdge				* aktual, * predchozi;			// ukazatel na aktualni a predchozi entitu


    // test existence uzlu tri
    assert((u[0] != NULL) && (u[1] != NULL));

    // cyklus uzlu
    for (int i = 0; i < 2; i++ )
    {
        // ulozeni prvniho souseda i-teho uzlu jako aktual
        aktual = u[i]->GetRegisteredEdge();

        // kontrola nenulovosti prvniho souseda i-teho uzlu
        assert(aktual != NULL);

        // test, neni-li aktualni soused this
        if (aktual == this)
            // vlozeni souseda pro i-ty uzel do i-teho uzlu
            u[i]->SetRegisteredEdge(s[i]);
        else
        {
            // cyklus sousedu pro i-ty uzel
            while(aktual != this)
            {
                // ulozeni aktualniho souseda do predchoziho
                predchozi = aktual;
                // ziskani dalsiho souseda registrovaneho u i-teho uzlu
                aktual = aktual->GetVertexEdge(u[i]);
                // kontrola dosazeni konce retezce registrovanych sousedu
                assert(aktual != NULL);
            }
            // preklenuti sousedu z predchoziho na souseda i-teho uzlu
            predchozi->SetVertexEdge(u[i], s[i]);
        }

        // vynulovani odkazu na souseda pro i-ty uzel
        s[i] = NULL;
    }
}

////////////////////////////////////////////////////////////
//

void MCEdge::DeserializeEntity(mds::mod::CChannelSerializer& Reader, std::vector<MCVertex *> & index_array)
{
  int        index0, index1;               // vertices


  // read vertices index from given channel
  Reader.readInt(index0);
  Reader.readInt(index1);
  if( Reader.isError() )
  {
    return;
  }

  assert((index0 < (int) index_array.size()) && (index0 >= 0));
  assert((index1 < (int) index_array.size()) && (index1 >= 0));

  // translation from vertices index on their pointers
  u[0] = index_array[index0];
  u[1] = index_array[index1];

  // deserialize MCEntity data
  MCEntity<MCEdge>::DeserializeEntity(Reader);
}

////////////////////////////////////////////////////////////
//

void MCEdge::SerializeEntity(mds::mod::CChannelSerializer& Writer)
{
  // vertices pointer existence test, not NULL
  assert((u[0] != NULL) && (u[1] != NULL));

  // translation from vertices pointer on their indexes
  // write vertices index into given channel
  Writer.writeInt(u[0]->GetIndex());
  Writer.writeInt(u[1]->GetIndex());

  // serialize MCEntity data
  MCEntity<MCEdge>::SerializeEntity(Writer);
}

////////////////////////////////////////////////////////////
//

//void MCEdge::()
//{
//}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
