//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2007 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsSerializer.cpp                   \n
 * Section: libModule                           \n
 * Date:    2003/11/17                          \n
 *
 * $Id:$
 *
 * Description:
 * -.
 */

#include <MDSTk/Module/mdsSerializer.h>

#include <MDSTk/Module/mdsBinarySerializer.h>
#include <MDSTk/Module/mdsSHMSerializer.h>


namespace mds
{
namespace mod
{

//==============================================================================
/*
 * Implementation of the class CSerializable.
 */
bool write(CSerializable& Entity, CChannel& Channel, unsigned int uiFlags)
{   
    // Check the channel type
    if( Channel.getMedium() == CH_SHM )
    {
        // SHM serializer
        CSHMSerializer Serializer(static_cast<CSharedMemChannel *>(&Channel), uiFlags);
        
        // Serialize the data entity
        return Serializer.writeRoot(Entity);
    }
    else
    {
        // Common channel serializer
        CBinarySerializer Serializer(&Channel, uiFlags);
        
        // Serialize the data entity
        return Serializer.writeRoot(Entity);
    }
}


bool read(CSerializable& Entity, CChannel& Channel, unsigned int uiFlags)
{
    // Check the channel type
    if( Channel.getMedium() == CH_SHM )
    {
        // SHM serializer
        CSHMSerializer Serializer(static_cast<CSharedMemChannel *>(&Channel), uiFlags);
        
        // Serialize the data entity
        return Serializer.readRoot(Entity);
    }
    else
    {
        // Common channel serializer
        CBinarySerializer Serializer(&Channel, uiFlags);

        // Serialize the data entity
        return Serializer.readRoot(Entity);
    }
}


} // namespace mod
} // namespace mds

