//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsException.cpp                    \n
 * Section: libBase                             \n
 * Date:    2003/10/23                          \n
 *
 * $Id: mdsException.cpp 116 2006-10-20 08:51:07Z spanel $
 * 
 * Description:
 * - Exception class.
 */

#include <MDSTk/Base/mdsException.h>


namespace mds
{

//==============================================================================
/*
 * Methods of the class mds::CException.
 */
const char *CException::what( ) const throw()
{
    return m_sReason.c_str();
}


const std::string& CException::getReason() const
{
    return m_sReason;
}


void CException::print(std::ostream& Stream) const
{
    Stream << '<' << m_sFilename << '>'
    << '<' << m_iLine << '>'
    << " Exception: " << m_sReason
    << std::endl;
}


std::ostream& operator <<(std::ostream& Stream, const CException& Exception)
{
    Exception.print(Stream);
    return Stream;
}


} // namespace mds

