//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsError.cpp                        \n
 * Section: libBase                             \n
 * Date:    2003/10/27                          \n
 *
 * $Id: mdsError.cpp 116 2006-10-20 08:51:07Z spanel $
 * 
 * Description:
 * - Error class.
 */

#include <MDSTk/Base/mdsError.h>


namespace mds
{

//==============================================================================
/*
 * Methods of the class mds::CError.
 */
void CError::print(std::ostream& Stream) const
{
    Stream << '<' << m_sFilename << '>'
        << '<' << m_iLine << '>'
        << " Error: " << m_sReason
        << std::endl;
}


std::ostream& operator <<(std::ostream& Stream, const CError& Error)
{
    Error.print(Stream);
    return Stream;
}


} // namespace mds

