////////////////////////////////////////////////////////////
// $Id: mctris.h 383 2007-06-21 12:17:06Z spanel $
////////////////////////////////////////////////////////////

#ifndef MCTRIS_H
#define MCTRIS_H

////////////////////////////////////////////////////////////
// include soubory

#include "mcentities.h"
#include "mcedges.h"

////////////////////////////////////////////////////////////
// definice maker

////////////////////////////////////////////////////////////
// definice namespace vctl

namespace vctl
{
/**
  * Kontejner 3D trojuhelniku typu MCTri.
  * Je odvozeno od obecneho kontejneru entit MCEntitieS.
  */

/** @todo Udelat iteratory pro prochazeni kontejneru entit (vertices, edges, tris, tetras). */

class MCTriS: public MCEntitieS<MCTri>
{
    ////////////////////////////////////////////////////////////
    // attributy   tridy

private:

    MCVerticeS                * vertices;                /**< Ukazatel na kontejner vrcholu site, na kterych je sit Tri postavena. */
    MCEdgeS                   edges;                     /**< Paralelni kontejner hran MCEdgeS, ktery muze zdilet se siti Tri vrcholy. */

    ////////////////////////////////////////////////////////////
    // macros for the class data serialisation and deserialisation, by CDataEntity class

public:

    //! Standard method getEntityName().
    MDS_ENTITY_NAME(MCTriS);

    //! Standard method getEntityCompression().
    MDS_ENTITY_COMPRESSION(mds::mod::CC_RAW);

    ////////////////////////////////////////////////////////////
    // funkce tridy

public:

    /** Konstruktor tridy MCTriS. */
    MCTriS()                                              { vertices = edges.GetVerticeS(); };
    /** Destruktor tridy MCTriS. */
    ~MCTriS()                                             { };

    /** Writes the triangular mesh. */
    void serialize(mds::mod::CChannelSerializer& Writer);
    /** Reads the triangular mesh. */
    void deserialize(mds::mod::CChannelSerializer& Reader);

    /** Reads triangles mesh from a given channel in binary STL format.
    *  @param Channel - given channel.
    *  @return  false on failure. */
    bool LoadSTL(mds::mod::CChannel& Channel);
    /** Writes the triangles mesh to a given channel in binary STL format.
     *  @param Channel - given channel.
     *  @return  false on failure. */
    bool SaveSTL(mds::mod::CChannel& Channel);
    /** Ulozeni kontejneru site Tri do souboru daneho jmena ve formatu VRML  .
     *  @param jm_soubor - reference na string se jmenem soubvoru pro VTML export kontejneru. */
    void SaveVRML(std::string   & jm_soubor);

    /** Vytvoreni noveho Tri na zaklade danych vrcholu.
     *  Provadi testovani existence Tri podle danych vrcholu.
     *  Podle vysledku testu vraci nalezeny nebo novy Tri.
     *  @param _n0 - ukazatel na prvni vrchol noveho Tri.
     *  @param _n1 - ukazatel na druhy vrchol noveho Tri.
     *  @param _n2 - ukazatel na treti vrchol noveho Tri.
     *  @return ukazatel na objekt noveho Tri nebo nalezeneho totozneho Tri. */
    MCTri * New(MCVertex * _u0, MCVertex * _u1, MCVertex * _u2);

    /** Vymazani daneho Tri z kontejneru.
     *  Provadi uvolneni vazeb na vrcholy a pameti vymazaneho Tri.
     *  Provadi odtrideni mazane entity z fronty.
     *  @param del_ent - ukazatel na objekt mazaneho Tri. */
    void Erase( MCTri * del_ent);

    /** Odregistrovani vsech Tri kontejneru z jejich vrcholu. */
    void DeRegistrationAll();

    /** Ziskani vsech Tri kolem hrany dane dvema jejimi vrcholy.
     *  Hledaji se Tri, ktere zdileji oba dane vrcholy.
     *  @param u0 - ukazatel na prvni dany vrchol testovane hrany. 
     *  @param u1 - ukazatel na druhy dany vrchol testovane hrany. 
     *  @param tri_pole - vektor ukazatelu na Tri zdilejici oba dane vrcholy. */
    void GetTriEdge( MCVertex * _u0, MCVertex * _u1, std::vector<MCTri *> & tri_pole );
    /** Ziskani poctu Tri kolem hrany dane dvema jejimi vrcholy.
     *  Pocitaji se Tri, ktere zdileji oba dane vrcholy.
     *  @param u0 - ukazatel na prvni dany vrchol testovane hrany. 
     *  @param u1 - ukazatel na druhy dany vrchol testovane hrany. 
     *  @return pocet Tri zdilejicich oba dane vrcholy. */
    int GetTriEdgeNumber( MCVertex * _u0, MCVertex * _u1);

    /** Test existence hrany dane dvema vrcholy v siti Tri kontejneru.
     *  @param _u0 - ukazatel na prvni vrchol testovane hrany.
     *  @param _u1 - ukazatel na druhy vrchol testovane hrany.
     *  @return priznak o existenci testovane hrany v siti Tri kontejneru. */
    bool TestEdgeExistence( MCVertex * _u0, MCVertex * _u1 );
    /** Test existence Tri daneho tremi vrcholy v kontejneru.
     *  @param _u0 - ukazatel na prvni vrchol testovaneho Tri.
     *  @param _u1 - ukazatel na druhy vrchol testovaneho Tri.
     *  @param _u2 - ukazatel na treti vrchol testovaneho Tri.
     *  @return ukazatel na nalezeny Tri nebo NULL, pokud v kontejneru neexistuje takove Tri. */
    MCTri * TestExistence(MCVertex * _u0, MCVertex * _u1, MCVertex * _u2);

    /** Test site Tri kontejneru na manifold (uzavrenost, regulernost).
     *  @return priznak, je-li sit Tri kontejneru manifold. */
    bool TestManifold();

    /** Ziskani ukazatele na kontejner vrcholu, na nichz je sit Tri postavena.
     *  @return ukazatel na kontejner vrcholu pro tento kontejner. */
    MCVerticeS * GetVerticeS()                           { return vertices; };
    /** Ziskani ukazatele na paralelni kontejner Hran, ktery je postaveny na stejnem kontejneru vrcholu.
     *  @return ukazatel na paralelni kontejner Hran pro tento kontejner. */
    MCEdgeS * GetEdgeS()                                 { return (&edges); };

    /** Vytvoreni hran pro vsechny Tri site. */
    void MakeAllTrisEdges();
    /** Vytvoreni hran daneho Tri.
      * @param _tri - ukazatel na tri jehoz hrany budou vytvareny. */
    void MakeTriEdges(MCTri * _tri);

    /** Vymazani hran site tri, ktere nezdileji zadny tri. */
    void EraseEdgesNoTris();
};
}
#endif

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
