////////////////////////////////////////////////////////////
// $Id: mcsphere.h 211 2007-01-04 12:45:37Z spanel $
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
// hlavickovy soubor objektu MCSphere

#ifndef MCSPHERE_H
#define MCSPHERE_H

////////////////////////////////////////////////////////////
// include soubory

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsSmallObject.h>

#include "mcentity.h"
#include "mcpoint3d.h"

#include <cstdio>
#include <memory.h>

////////////////////////////////////////////////////////////
// definice maker

////////////////////////////////////////////////////////////
// definice namespace vctl

namespace vctl
{
////////////////////////////////////////////////////////////
// hlavicka objektu MCSphere

/**
 * Zapouzdreni obsluhy vektoroveho 3D objektu koule.
 * Jsou pripraveny funkce pro sestrojeni koule opsane hrane, trojuhelniku a tetrahedru.
 * Alokace jako maly objekt pres Loki::SmallObject.
 */

class MCSphere : public mds::base::CSmallObject<>
{
private:
    double               radius;          /**< Polomer koule. */
    MCPoint3D            stred;           /**< Stred koule. */

public:

    /** Konstruktor tridy MCSphere. */
    MCSphere()                                         { radius = 0; };
    /** Destruktor tridy MCSphere. */
    ~MCSphere()                                        {};

    /** Ziskani parametru koule.
     *  @param _cx - ukazatel na ziskanou souradnici v ose X stredu koule.
     *  @param _cy - ukazatel na ziskanou souradnici v ose Y stredu koule.
     *  @param _cz - ukazatel na ziskanou souradnici v ose Z stredu koule.
     *  @param _r  - ukazatel na ziskany polomer koule. */
    void GetSphere(double & _cx,  double & _cy,  double & _cz,  double & _r)
    { stred.GetXYZ(_cx, _cy, _cz); _r = radius; };

    /** Ziskani 3D bodu stredu koule.
     *  @param _point - ukazatel na ziskany 3D bod stredu koule. */
    void GetCenter(MCPoint3D & _point)                 { stred.GetPoint3D(_point); };
    /** Ziskani 3D bodu stredu koule.
     *  @return constant ukazatel na vraceny 3D bod stredu koule. */
    const MCPoint3D * GetCenter()                      { return &stred; };

    /** Vytvoreni opsane koule pro tetrahedr podle danych ctyr vrcholu.
     *  @param n1 - ukazatel na vrchol daneho tetrahedru.
     *  @param n2 - ukazatel na vrchol daneho tetrahedru.
     *  @param n3 - ukazatel na vrchol daneho tetrahedru.
     *  @param n4 - ukazatel na vrchol daneho tetrahedru. */
    void MakeSphereTetra(MCVertex * n1, MCVertex * n2, MCVertex * n3, MCVertex * n4);
    /** Vytvoreni opsane koule pro trojuhelnik podle danych trech vrcholu.
     *  @param n1 - ukazatel na vrchol daneho trojuhelnika.
     *  @param n2 - ukazatel na vrchol daneho trojuhelnika.
     *  @param n3 - ukazatel na vrchol daneho trojuhelnika. */
    void MakeSphereTri(MCVertex * n1, MCVertex * n2, MCVertex * n3);
    /** Vytvoreni opsane koule pro hranu podle danych dvou vrcholu.
     *  @param n1 - ukazatel na vrchol dane hrany.
     *  @param n2 - ukazatel na vrchol dane hrany. */
    void MakeSphereEdge(MCVertex * n1, MCVertex * n2);

    /** Testovani daneho 3D bodu, jestli je uvnitr, na povrchu nebo vne koule.
     *  @param _point - reference na testovany 3D bod.
     *  @return hodnota vysledneho stavu testu.
     *  @return 1 = testovany 3D bod lezi uvnitr koule.
     *  @return 0 = testovany 3D bod lezi na kouli, na povrchu, hranici.
     *  @return -1 = testovany 3D bod lezi mimo koule, vne. */
    int TestPoint(MCPoint3D & _point);

private:

    /** Vyreseni korenu dane matice 4x4 soustavy linearnich rovnic Gausovou eliminaci.
     *  Koreny rovnic jsou chapany jako stred resene koule.
     *  @param matice - pole jako dana soustava rovnic, matice 4x4 prvku typu double.
     *  @param vysledek - reference na vysledny stred koule.
     *  @return stav uspesnosti reseni soustavy.
     *  @return 0 = reseni probehlo OK.
     *  @return -1 = reseni neprobehlo OK, soustava nema reseni, deleni nulou. */
    static int GausElimin(double * matice, MCPoint3D & vysledek);

};
}
#endif

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
