////////////////////////////////////////////////////////////
// $Id: mcpoint3d.h 196 2006-12-16 22:38:23Z krsek $
////////////////////////////////////////////////////////////

#ifndef MCPOINT3D_H
#define MCPOINT3D_H

////////////////////////////////////////////////////////////
// include soubory

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsSmallObject.h>

#include "mccoordinate3d.h"

#include <math.h>
#include <fstream>
#include <stdexcept>

////////////////////////////////////////////////////////////
// definice maker

////////////////////////////////////////////////////////////
// definice namespace vctl

namespace vctl
{
////////////////////////////////////////////////////////////
// hlavicka tridy MCPoint3D

/**
 * Zapouzdreni obsluhy a prace s bodem ve 3D prostoru se souradnicemi typu double.
 * Odvozeno od sablony MCCoordinate3D pro 3D souradnice typu double.
 * Alokace jako maly objekt pres Loki::SmallObject.
 */

class MCPoint3D: public MCCoordinate3D<double>, public mds::base::CSmallObject<>
{
    ////////////////////////////////////////////////////////////
    // attributy tridy

protected:

    ////////////////////////////////////////////////////////////
    // funkce tridy

public:

    /** MCEntity class constructor. */
    MCPoint3D()                                         { };
    /** Konstruktor tridy MCEntity, s parametry referenci na souradnice bodu. */
    //MCPoint3D(double & _x, double & _y, double & _z)    { SetXYZ(_x, _y, _z); };
    /** Konstruktor tridy MCEntity, s parametry hodnot souradnic bodu. */
    MCPoint3D(double _x, double _y, double _z)          { SetXYZ(_x, _y, _z); };
    /** Konstruktor tridy MCEntity, s parametrem ukazatele na 3D bod pro nastaveni souradnic. */
    MCPoint3D(MCPoint3D * _point)                       { assert(_point != NULL); x = _point->x; y = _point->y; z = _point->z; };

    /** Destruktor tridy MCEntity. */
    virtual ~MCPoint3D()                                {};

    /** Ziskani souradnic bodu a jejnich nastaveni do daneho 3D bodu. */
    void GetPoint3D( MCPoint3D & _point )               { _point.x = x; _point.y = y; _point.z = z; };
    /** Nastaveni souradnic bodu podle daneho 3D bodu. */
    void SetPoint3D( MCPoint3D & _point )               { x = _point.x; y = _point.y; z = _point.z; };

    /** Get coordinates sum. */
    double GetSumaXYZ()                                 { return (x + y + z); };
    /** Get coordinates product. */
    double GetMultipleXYZ()                             { return (x * y * z); };

    /** Vypocet vzdalenosti bodu od daneho bodu. */
    double Distance( MCPoint3D & b2 )                   { return ( sqrt( (x - b2.x) * (x - b2.x) + (y - b2.y) * (y - b2.y) + (z - b2.z) * (z - b2.z) ) ); };
    /** Vypocet vzdalenosti dvou danych bodu. */
    static double Distance( MCPoint3D & b1, MCPoint3D & b2 )   { return (b1.Distance(b2)); };

    /** Vypocet druhe mocniny vzdalenosti bodu od daneho bodu. */
    double SquareDistance( MCPoint3D & b2 )             { return ( (x - b2.x) * (x - b2.x) + (y - b2.y) * (y - b2.y) + (z - b2.z) * (z - b2.z) ); };
    /** Vypocet vzdalenosti dvou danych bodu. */
    static double SquareDistance( MCPoint3D & b1, MCPoint3D & b2 )   { return (b1.SquareDistance(b2)); };
};
}

#endif

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
