////////////////////////////////////////////////////////////
// $Id: mclistnode.h 164 2006-12-08 20:26:48Z krsek $
////////////////////////////////////////////////////////////

#ifndef MCLISTNODE_H
#define MCLISTNODE_H

////////////////////////////////////////////////////////////
// include soubory

#include <cstdlib>

////////////////////////////////////////////////////////////
// definice maker

////////////////////////////////////////////////////////////
// definice namespace vctl

namespace vctl
{
/** Sablona prveku oboustranneho spojoveho seznamu pro kontejner MCList. */

template <typename NODE_TYPE> class MCListNode
{
    ////////////////////////////////////////////////////////////
    // attributy tridy

private:

    NODE_TYPE     * prev_node;              /**< Ukazatel na predchozi prvek spojoveho seznamu. */
    NODE_TYPE     * next_node;              /**< Ukazatel na nasledujici prvek spojoveho seznamu. */

    ////////////////////////////////////////////////////////////
    // funkce tridy

public:

    /** Konstruktor tridy MCListNode.
     *  Provadi inicializaci atributu tridy. */
    MCListNode()                                           { prev_node = NULL; next_node = NULL; };
    /** Destruktor tridy MCListNode. */
    virtual ~MCListNode()                                  {};

    /** Ziskani ukazatele na predchozi prvek oboustranneho spojoveho seznamu.
     *  @return ukazatel na predchozi prvek seznamu. */
    NODE_TYPE * GetPrev()                                 { return prev_node; };
    /** Ziskani ukazatele na nasledujici prvek oboustranneho spojoveho seznamu.
     *  @return ukazatel naz nasledujici prvek seznamu. */
    NODE_TYPE * GetNext()                                 { return next_node; };

    /** Nastaveni ukazatele na predchozi prvek oboustranneho spojoveho seznamu.
     *  @param _node - ukazatel na novy predchozi prvek seznamu. */
    void SetPrev( NODE_TYPE * _node )                     { prev_node = _node; };
    /** Nastaveni ukazatele na nasledujici prvek oboustranneho spojoveho seznamu.
     *  @param _node - ukazatel na novy nasledujici prvek seznamu. */
    void SetNext( NODE_TYPE * _node )                     { next_node = _node; };
};
}

#endif

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////




