////////////////////////////////////////////////////////////
// $Id: mclist.h 164 2006-12-08 20:26:48Z krsek $
////////////////////////////////////////////////////////////

#ifndef MCLIST_H
#define MCLIST_H

////////////////////////////////////////////////////////////
// include soubory

#include "mclistnode.h"

#include <assert.h>

////////////////////////////////////////////////////////////
// definice maker

////////////////////////////////////////////////////////////
// definice namespace vctl

namespace vctl
{
/** Sablona kontejneru prvku odvozenych od MCListNode implementovany 
  * jako oboustranny spojovy seznam. Prvky seznamu jsou tridy typu MCListNode. */

template <typename NODE_TYPE> class MCList
{
    ////////////////////////////////////////////////////////////
    // attributy tridy

protected:

    int              list_node_number;       /**< Pocet uzlu v retezu. */
    NODE_TYPE        * first_node;           /**< Ukazatel na prvni uzel retezu. */
    NODE_TYPE        * last_node;            /**< Ukazatel na posledni uzel retezu. */

    ////////////////////////////////////////////////////////////
    // funkce tridy

public:

    /** Konstruktor tridy MCList.
     *  Provadi inicializaci atributu tridy. */
    MCList()                                               { list_node_number= 0; first_node = NULL; last_node = NULL; };
    /** Destruktor tridy MCList. */
    ~MCList()                                              {};

    /** Ziskani ukazatele na prvni uzel retezu.
     *  Nekontroluje, jestli retez obsahuje nejake prvky.
     *  Pokud ne, vraci hodnotu firt)node, coz by melo byt NULL.
     *  @return ukazatel na prvni prvek retezu. */
    NODE_TYPE * GetFirst()                                { return first_node; };
    /** Ziskani ukazatele na posledni uzel retezu.
     *  Nekontroluje, jestli retez obsahuje nejake prvky.
     *  Pokud ne, vraci hodnotu firt)node, coz by melo byt NULL.
     *  @return ukazatel na posledni prvek retezu. */
    NODE_TYPE * GetLast()                                 { return last_node; };

    /** Ziskani poctu uzlu retezu.
     *  @return pocet uzlu retezu. */
    int GetNumber()                                        { return list_node_number; };

protected:

    /** Nulovani, vyprazdneni retezu.
     *  Inicializuje atributy tridy. */
    void ClearAllNode()                                    { first_node = NULL; last_node = NULL; list_node_number = 0; };

    /** Pridani daneho uzlu do retezu, na konec.
     *  @param new_node - ukazatel na vkladany uzel. */
    void AddNode( NODE_TYPE * new_node )
    {
      // test existence daneho ukazatele
      assert(new_node != NULL);

      // pripojeni noveho uzlu do retezu
      if (list_node_number == 0)
      {
        // nastaveni pridavaneho uzlu jako prvniho a posledniho
        last_node = first_node = new_node;
        // vynulovani ukazatelu na predchozi a nasledujici pro novy uzel
        new_node->SetPrev(NULL);
        new_node->SetNext(NULL);
      }
      else
      {
        // zacleneni pridavaneho uzlu do retezu na konec
        last_node->SetNext(new_node);
        new_node->SetPrev(last_node);
        last_node = new_node;
        // vynulovani ukazatelu na nasledujici pro novy uzel
        new_node->SetNext(NULL);
      }

      // inkrementace poctu
      list_node_number++;
    };

    /** Vymazani daneho uzlu z retezu.
     *  @param erase_node - ukazatel na mazany uzel. */
    void EraseNode( NODE_TYPE * erase_node )
    {
      // test existence daneho ukazatele
      assert(erase_node != NULL);

      // test nuloveho poctu prvku retezu
      if (list_node_number != 0)
      {
        // test, neni-li mazany uzel prvnim uzlem
        if (erase_node == first_node)
        {
          // nastaveni noveho prvniho uzlu
          first_node = erase_node->GetNext();
          // nulovani predchudce noveho prvniho uzlu, pokud existuje
          if (first_node != NULL)
            first_node->SetPrev(NULL);
        }
        // test, neni-li mazany uzel poslednim uzlem
        else if (erase_node == last_node)
        {
          // nastaveni noveho posledniho uzlu
          last_node = erase_node->GetPrev();
          // nulovani nasledovnika noveho posledniho uzlu, pokud existuje
          if (last_node != NULL)
            last_node->SetNext(NULL);
        }
        else // odstranovany uzel je uprostred retezu
        {
          // premostit predchoziho na nasledujiciho a naopak pro vyhazovany uzel
          erase_node->GetPrev()->SetNext(erase_node->GetNext());
          erase_node->GetNext()->SetPrev(erase_node->GetPrev());
        }

        // vynulovani ukazatelu na sousedy v odstranovanem uzlu
        erase_node->SetPrev(NULL);
        erase_node->SetNext(NULL);

        // dekrementace poctu node
        list_node_number--;
      }
    };
};
}

#endif

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
