////////////////////////////////////////////////////////////
// $Id: mcentities.h 383 2007-06-21 12:17:06Z spanel $
////////////////////////////////////////////////////////////

#ifndef MCENTITIES_H
#define MCENTITIES_H

////////////////////////////////////////////////////////////
// include soubory

// MDSTk
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Module/mdsSerializer.h>

#include "mclist.h"
#include "mcentity.h"
#include "mcqueue.h"

#include <fstream>
#include <stdexcept>

////////////////////////////////////////////////////////////
// definice maker

////////////////////////////////////////////////////////////
// definice namespace vctl

namespace vctl
{
/**
  * Sablona kontejneru obecnych vektorovych entit odvozenych od MCEntity.
  * Je odvozeno od sablony seznamu MCList.
  */

template <typename ENTITY_TYPE> class MCEntitieS: public MCList<ENTITY_TYPE> , public mds::mod::CSerializable
{
    ////////////////////////////////////////////////////////////
    // typy tridy

public:

    typedef MCQueue<double, ENTITY_TYPE>  MT_QUEUE;   /**< Typ fronty pro razeni entit. */
    typedef MCList<ENTITY_TYPE> MT_LIST;

    ////////////////////////////////////////////////////////////
    // attributy tridy

protected:

    MT_QUEUE          fronta;         /**< Fronta pro razeni entit. */

private:

    ////////////////////////////////////////////////////////////
    // funkce tridy

public:

    /** Konstruktor tridy MCEntities. */
    MCEntitieS()                                            {};
    /** Destruktor tridy MCEntities. */
    virtual ~MCEntitieS()                                   { ClearAll(); };

    /** Ziskani ukazatele na frontu pro trideni entit kontejneru.
    *  @return ukazatel na objekt fronty typu MCQueue pro trideni entit. */
    MT_QUEUE * GetQueue()                                   { return &fronta; };

    /** Zatrideni dane entity do fronty.
    *  U dane entity se predpoklada nastaveni atributu "value" pro trideni. 
    *  @param[in] _entita - ukazatel na entitu pro zatrideni. */
    void Sort(ENTITY_TYPE * _entita)                          { assert(_entita != NULL); fronta.Sort(_entita->GetValue(), _entita); };
    /** Odtrideni dane entity z fronty.
    *  U dane entity se predpoklada nastaveni atributu "value" pro odtrideni.
    *  @param[in] _entita - ukazatel na entitu pro odtrideni. */
    void UnSort(ENTITY_TYPE * _entita)                        { assert(_entita != NULL); fronta.UnSort(_entita->GetValue(), _entita); };

    /** Vymazani vsech entit kontejneru. Virtualni funkce. */
    virtual void ClearAll()
    {
      ENTITY_TYPE      * aktual = MT_LIST::GetFirst(), * dalsi;      // ukazatel na aktualni a dalsi entitu


      // cyklus entit kontejneru
      while (aktual != NULL)
      {
        // ziskani nasledujici entity
        dalsi = aktual->GetNext();
        // vymazani objektu aktualni entity
        delete(aktual);
        // nastaveni nasledujici entity jako aktualni
        aktual = dalsi;
      }

      // uvolneni fronty
      fronta.Clear();

      // nulovani retezu uzlu
      MT_LIST::ClearAllNode();
    };

    /** Setrideni vsech entit v kontejneru s pouzitim fronty.
     *  U vsech entit kontejneru se predpoklada nastaveni atributu "value" pro trideni. */
    void SortAll()
    {
      ENTITY_TYPE         * aktual = MT_LIST::GetFirst();           // ukazatel na prvni aktualni entitu

      // nulovani fronty
      fronta.Clear();

      // cyklus vsech existujicich entit
      while (aktual != NULL)
      {
        // zatrideni aktualni entity
        fronta.Sort(aktual->GetValue(), aktual);
        // ziskani nasledujici entity
        aktual = aktual->GetNext();
      }
    };
};
}

#endif

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
