////////////////////////////////////////////////////////////
// $Id: mcedges.h 383 2007-06-21 12:17:06Z spanel $
////////////////////////////////////////////////////////////

#ifndef MCEDGES_H
#define MCEDGES_H

////////////////////////////////////////////////////////////
// include soubory

#include "mcvertices.h"
#include "mcentities.h"

////////////////////////////////////////////////////////////
// definice maker

////////////////////////////////////////////////////////////
// definice namespace vctl

namespace vctl
{
/**
  * Kontejner 3D hran typu MCEdge.
  * Je odvozeno od obecneho kontejneru entit MCEntitieS.
  */

class MCEdgeS: public MCEntitieS<MCEdge>
{
    ////////////////////////////////////////////////////////////
    // attributy tridy

private:

    MCVerticeS                  vertices;        /**< Kontejner vrcholu na nichz jsou postaveny hrany. */

public:

    //! Standard method getEntityName().
    MDS_ENTITY_NAME(MCVerticeS);

    //! Standard method getEntityCompression().
    MDS_ENTITY_COMPRESSION(mds::mod::CC_RAW);

    ////////////////////////////////////////////////////////////
    // funkce tridy

public:

    /** Konstruktor tridy MCEdgeS. */
    MCEdgeS()                                              { };
    /** Destruktor tridy MCEdgeS. */
    ~MCEdgeS()                                             { };

    /** Writes the edges container. */
    void serialize(mds::mod::CChannelSerializer& Writer);
    /** Reads the edges container. */
    void deserialize(mds::mod::CChannelSerializer& Reader);

    /** Vytvoreni nove hrany na zaklade danych vrcholu.
     *  Provadi testovani existence hrany podle danych vrcholu.
     *  Podle vysledku testu vraci nalezenou nebo novou hranu.
     *  @param n0 - ukazatel na prvni vrchol nove hrany.
     *  @param n1 - ukazatel na druhy vrchol nove hrany.
     *  @return ukazatel na objekt nove hrany nebo nalezene totozne hrany. */
    MCEdge * New( MCVertex * _u0, MCVertex * _u1 );

    /** Vymazani dane hrany z kontejneru.
     *  Provadi uvolneni vazeb na vrcholy a pameti vymazane hrany.
     *  Provadi odtrideni mazane entity z fronty.
     *  @param del_ent - ukazatel na objekt mazane hrany */
    void Erase( MCEdge * del_ent);

    /** Odregistrovani vsech Edge kontejneru z jejich vrcholu. */
    void DeRegistrationAll();

    /** Ziskani ukazatele na kontejner vrcholu, na nichz jsou hrany postaveny.
     *  @return ukazatel na kontejner vrcholu pro tento kontejner. */
    MCVerticeS * GetVerticeS()                             { return &vertices; };

    /** Test existence hrany dane dvema vrcholy v kontejneru.
     *  @param _u0 - ukazatel na prvni vrchol testovane hrany.
     *  @param _u1 - ukazatel na druhy vrchol testovane hrany.
     *  @return ukazatel na nalezenou hranu nebo NULL, pokud v kontejneru neexistuje takova hrana. */
    MCEdge * TestExistence(MCVertex * _u0, MCVertex * _u1);
};
}

#endif

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
