////////////////////////////////////////////////////////////
// $Id: mccoordinate3d.h 200 2006-12-20 13:19:29Z spanel $
////////////////////////////////////////////////////////////

#ifndef MCCOORDINATE3D_H
#define MCCOORDINATE3D_H

////////////////////////////////////////////////////////////
// include soubory

#include <cmath>

////////////////////////////////////////////////////////////
// definice maker

////////////////////////////////////////////////////////////
// definice namespace vctl

namespace vctl
{
/** Sablona pro zapouzdreni typove nezavisle souradnice ve 3D prostoru. */

template <typename T> class MCCoordinate3D
{
    ////////////////////////////////////////////////////////////
    // attributy tridy

protected:

    T               x;            /**< Hodnota souradnice v ose X. */
    T               y;            /**< Hodnota souradnice v ose Y. */
    T               z;            /**< Hodnota souradnice v ose Z. */

    ////////////////////////////////////////////////////////////
    // funkce tridy

public:

    /** Konstruktor objektu MCCoordinate3D.
     *  Provadi nulovani souradnic. */
    MCCoordinate3D()                                     { x = 0; y = 0; z = 0; };

    /** Destruktor objektu MCCoordinate3D .*/
    virtual ~MCCoordinate3D()                            {};

    /** Ziskani hodnoty souradnice v ose X.
     *  @return hodnota souradnice v ose X. */
    T GetX()                                             { return x; };
    /** Ziskani hodnoty souradnice v ose Y.
     *  @return hodnota souradnice v ose Y. */
    T GetY()                                             { return y; };
    /** Ziskani hodnoty souradnice v ose Z.
     *  @return hodnota souradnice v ose Z. */
    T GetZ()                                             { return z; };
    /** Ziskani hodnot XYZ souradnic.
     *  @param _x - ukazatel na vracenou hodnotu souradnice v ose X.
     *  @param _y - ukazatel na vracenou hodnotu souradnice v ose Y.
     *  @param _z - ukazatel na vracenou hodnotu souradnice v ose Z. */
    void GetXYZ(T & _x, T & _y, T & _z)                  { _x = x; _y = y; _z = z; };
    /** Save actual coordinates (X,Y,Z) into a given array. */
    void GetXYZ(T _xyz[3])                               { _xyz[0] = x; _xyz[1] = y; _xyz[2] = z; };

    /** Nastaveni hodnoty souradnice v ose X.
     *  Virtualni metoda.
     *  @param _x - hodnota nove souradnice v ose X. */
    virtual void SetX(T _x)                              { x = _x; };
    /** Nastaveni hodnoty souradnice ose Y.
     *  Virtualni metoda.
     *  @param _y - hodnota nove souradnice v ose Y. */
    virtual void SetY(T _y)                              { y = _y; };
    /** Nastaveni hodnoty souradnice v ose Z.
     *  Virtualni metoda.
     *  @param _z - hodnota nove souradnice v ose Z. */
    virtual void SetZ(T _z)                              { z = _z; };
    /** Nastaveni hodnot XYZ souradnic.
     *  Virtualni metoda.
     *  @param _x - hodnota nove souradnice v ose X.
     *  @param _y - hodnota nove souradnice v ose y.
     *  @param _z - hodnota nove souradnice v ose z. */
    virtual void SetXYZ(T _x, T _y, T _z)          { x = _x; y = _y; z = _z; };

};
}
#endif

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
