//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsSystemTypes.h                    \n
 * Section: libSystem                           \n
 * Date:    2005/09/14                          \n
 *
 * $Id: mdsSystemTypes.h 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Basic types definition.
 */

#ifndef MDS_SYSTEMTYPES_H
#define MDS_SYSTEMTYPES_H

#include <MDSTk/Base/mdsSetup.h>

// Windows version
#ifdef _WIN32
//#    include <windows.h>
#endif // _WIN32

// Linux version
#ifdef _LINUX
#    include <sys/types.h>
#endif // _LINUX


namespace mds
{
namespace sys
{

//=============================================================================
/*
 * Global definitions.
 * - Windows version.
 */

#ifdef _WIN32

/*//! Basic system types.
typedef __int8              tInt8;
typedef unsigned __int8     tUInt8;
typedef __int16             tInt16;
typedef unsigned __int16    tUInt16;
typedef __int32             tInt32;
typedef unsigned __int32    tUInt32;*/

//! Basic system types.
typedef char                tInt8;
typedef unsigned char       tUInt8;
typedef short               tInt16;
typedef unsigned short      tUInt16;
typedef int                 tInt32;
typedef unsigned int        tUInt32;

#endif // _WIN32


//=============================================================================
/*
 * Global definitions.
 * - Linux version.
 */

#ifdef _LINUX

//! Basic system types.
typedef __int8_t            tInt8;
typedef __uint8_t           tUInt8;
typedef __int16_t           tInt16;
typedef __uint16_t          tUInt16;
typedef __int32_t           tInt32;
typedef __uint32_t          tUInt32;

#endif // _LINUX


} // namespace sys
} // namespace mds

#endif // MDS_SYSTEMTYPES_H

