//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsStopwatch.h                      \n
 * Section: libSystem                           \n
 * Date:    2003/10/24                          \n
 *
 * $Id: mdsStopwatch.h 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Time difference measuring.
 */

#ifndef MDS_STOPWATCH_H
#define MDS_STOPWATCH_H

#include <MDSTk/Base/mdsSetup.h>

// Windows version
#ifdef _WIN32
#    include <windows.h>
#endif // _WIN32

// Linux version
#ifdef _LINUX
#endif // _LINUX

#include <MDSTk/Base/mdsSharedPtr.h>

#include "mdsSystem.h"


namespace mds
{
namespace sys
{

//==============================================================================
/*!
 * Class for time difference measuring.
 */
class CStopwatch : public mds::CObject
{
public:
    //! Standard method getClassName().
    MDS_CLASS_NAME(CStopwatch);

    //! Smart pointer type.
    MDS_SHAREDPTR(CStopwatch);

public:
    //! Default constructor.
    CStopwatch();

    //! Virtual destructor.
    virtual ~CStopwatch();

    //! Starts the time measuring.
    void start();

    //!    Elapsed time in milliseconds.
    unsigned long getDuration();

protected:
#ifdef _WIN32
    //! Time of the last CStopwatch::start() call.
    LARGE_INTEGER liStart;

    //! Frequency of the performance timer.
    LARGE_INTEGER liFrequency;
#endif // _WIN32

#ifdef _LINUX
    //! Time of the last CStopwatch::start() call.
    unsigned long ulStart;

    //! Frequency of the performance timer.
    unsigned long ulFrequency;

    //! Returns current system time in milliseconds.
    unsigned long getCurrentTime();
#endif // _LINUX

private:
    //! Private copy constructor.
    CStopwatch(const CStopwatch&);

    //! Private assignment operator.
    void operator=(const CStopwatch&);
};


//==============================================================================
/*!
 * Smart pointer to the mutex.
 */
typedef CStopwatch::tSmartPtr   CStopwatchPtr;


} // namespace sys
} // namespace mds

#endif // MDS_STOPWATCH_H

