//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsMutex.h                          \n
 * Section: libSystem                           \n
 * Date:    2003/10/24                          \n
 *
 * $Id: mdsMutex.h 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Mutual exclusion.
 */

#ifndef MDS_MUTEX_H
#define MDS_MUTEX_H

#include <MDSTk/Base/mdsSetup.h>

// Windows version
#ifdef _WIN32
#    include <windows.h>
#endif // _WIN32

// Linux version
#ifdef _LINUX
#    include <unistd.h>
#    include <pthread.h>
#endif // _LINUX

#include <MDSTk/Base/mdsSharedPtr.h>

#include "mdsSystem.h"


namespace mds
{
namespace sys
{

//==============================================================================
/*!
 * Class providing simple mutual exclusion.
 */
class CMutex : public mds::CObject
{
public:
    //! Standard method getClassName().
    MDS_CLASS_NAME(CMutex);

    //! Smart pointer type.
    MDS_SHAREDPTR(CMutex);

public:
    //! Constructor that creates a new mutex.
    CMutex(bool bLocked = false);

    //! Virtual destructor.
    virtual ~CMutex();

    //! Locks the mutex.
    void lock();

    //! Releases ownership of the mutex.
    void unlock();

protected:
#ifdef _WIN32
    //! Windows mutex.
    HANDLE m_hMutex;
#endif // _WIN32

#ifdef _LINUX
    //! Linux mutex.
    pthread_mutex_t m_Mutex;
#endif // _LINUX

private:
    //! Private copy constructor.
    CMutex(const CMutex&);

    //! Private assignment operator.
    void operator=(const CMutex&);
};


//==============================================================================
/*!
 * Smart pointer to the mutex.
 */
typedef CMutex::tSmartPtr   CMutexPtr;


} // namespace sys
} // namespace mds

#endif // MDS_MUTEX_H

