//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2005 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsEnvironment.h                    \n
 * Section: libSystem                           \n
 * Date:    2003/10/29                          \n
 *
 * $Id: mdsEnvironment.h 139 2006-11-14 19:59:15Z spanel $
 *
 * Description:
 * - Definition of various platform dependent system constants
 */

#ifndef MDS_ENVIRONMENT_H
#define MDS_ENVIRONMENT_H


//=============================================================================
/*
 * System definitions.
 */

// Includes POSIX and XOPEN linux extensions
#ifdef _LINUX
#   define _POSIX_C_SOURCE      199506L
#   define _XOPEN_SOURCE        500
#   define _REENTRANT
#endif // _LINUX

// Disable security warnings generated by MS Visual C++ 2005 compiler
#if defined(_MSC_VER) && (_MSC_VER >= 1400)
#   pragma warning(disable:4996)
#endif // _MSC_VER


#endif    // MDS_ENVIRONMENT_H

