//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsVectorBase.h                     \n
 * Section: libMath                             \n
 * Date:    2006/02/12                          \n
 *
 * $Id: mdsVectorBase.h 375 2007-06-19 14:42:03Z spanel $
 *
 * Description:
 * - Base class for all vectors.
 */

#ifndef MDS_VECTORBASE_H
#define MDS_VECTORBASE_H

#include <MDSTk/Base/mdsSetup.h>


namespace mds
{
namespace math
{

//==============================================================================
/*!
 * Base class for all vectors.
 * - Base class takes a template parameter V. This parameter is the type
 *   of the class which derives from it (so called curiously recurring template
 *   pattern).
 */
template <class V>
class CVectorBase
{
public:
    //! Vector type.
    typedef V tVector;
    
public:
    //! Returns reference to the vector implementation.
    tVector& getImpl()
    {
        return *static_cast<tVector *>(this);
    }
    const tVector& getImpl() const
    {
        return *static_cast<const tVector *>(this);
    }

protected:
    //! Default constructor.
    CVectorBase() {}

    //! Copy constructor.
    CVectorBase(const CVectorBase&) {}

    //! Assignment operator.
    CVectorBase& operator =(const CVectorBase&) {}
};


} // namespace math
} // namespace mds

#endif // MDS_VECTORBASE_H

