//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsMatrixFunctions.h                \n
 * Section: libMath                             \n
 * Date:    2006/02/15                          \n
 *
 * $Id: mdsMatrixFunctions.h 110 2006-10-12 21:25:52Z spanel $
 *
 * Description:
 * - Basic matrix functions and operations.
 */

#ifndef MDS_MATRIXFUNCTIONS_H
#define MDS_MATRIXFUNCTIONS_H

#include <MDSTk/Base/mdsSetup.h>


//==============================================================================
/*
 * Include all predefined matrix functions.
 */

// General matrix functions
#include "MatrixFunctions/mdsGeneral.h"

// Special matrix funtions
#include "MatrixFunctions/mdsDeterminant.h"
#include "MatrixFunctions/mdsInverse.h"
#include "MatrixFunctions/mdsEig.h"


#endif // MDS_MATRIXFUNCTIONS_H

