//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    mdsMatrixBase.h                     \n
 * Section: libMath                             \n
 * Date:    2006/02/12                          \n
 *
 * $Id: mdsMatrixBase.h 375 2007-06-19 14:42:03Z spanel $
 *
 * Description:
 * - Base class for all two-dimensional matrixes.
 */

#ifndef MDS_MATRIXBASE_H
#define MDS_MATRIXBASE_H

#include <MDSTk/Base/mdsSetup.h>


namespace mds
{
namespace math
{

//==============================================================================
/*!
 * Base class for all two-dimensional matrixes.
 * - Base class takes a template parameter M. This parameter is the type
 *   of the class which derives from it (so called curiously recurring template
 *   pattern).
 */
template <class M>
class CMatrixBase
{
public:
    //! Matrix type.
    typedef M tMatrix;

public:
    //! Returns reference to the matrix implementation.
    tMatrix& getImpl()
    {
        return *static_cast<tMatrix *>(this);
    }
    const tMatrix& getImpl() const
    {
        return *static_cast<const tMatrix *>(this);
    }

protected:
    //! Default constructor.
    CMatrixBase() {}

    //! Copy constructor.
    CMatrixBase(const CMatrixBase&) {}

    //! Assignment operator.
    CMatrixBase& operator =(const CMatrixBase&) {}
};


} // namespace math
} // namespace mds

#endif // MDS_MATRIXBASE_H

