//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    VectorFunctions/mdsConversion.hxx   \n
 * Section: libMath                             \n
 * Date:    2006/09/15                          \n
 *
 * $Id: mdsConversion.hxx 331 2007-04-17 14:43:06Z spanel $
 *
 * Description:
 * - Vector conversion functions.
 */


//==============================================================================
/*
 * Helper functions.
 */

//! Specialization of the function.
template <typename T>
inline const T& makeVectorImpl(const T& Value, SVectorType)
{
    return Value;
}


//! Specialization of the function.
template <typename T>
inline T& makeVectorImpl(T& Value, SVectorType)
{
    return Value;
}


//! Specialization of the function.
template <typename T>
inline CStaticVector<T,1> makeVectorImpl(T& Value, SFundamentalType)
{
    return CStaticVector<T,1>(Value);
}


//! Specialization of the function.
template <typename T>
inline CStaticVector<T,1> makeVectorImpl(const T& Value, SFundamentalType)
{
    return CStaticVector<T,1>(Value);
}


//==============================================================================
/*
 * Functions templates.
 */

template <typename T>
inline typename SMakeVector<T>::tResult makeVector(const T& Value)
{
    typedef typename SMakeVector<T>::tType tType;
    
    return makeVectorImpl<T>(Value, tType());
}

