//==============================================================================
/*! \file
 * Medical Data Segmentation Toolkit (MDSTk)    \n
 * Copyright (c) 2003-2006 by Michal Spanel     \n
 *
 * Author:  Michal Spanel, spanel@fit.vutbr.cz  \n
 * File:    MatrixFunctions/mdsInverse.h        \n
 * Section: libMath                             \n
 * Date:    2006/02/16                          \n
 *
 * $Id: mdsInverse.h 64 2006-08-11 08:45:24Z spanel $
 *
 * Description:
 * - Computes inverse of a square matrix.
 */

#ifndef MDS_MATRIXFUNCTIONS_INVERSE_H
#define MDS_MATRIXFUNCTIONS_INVERSE_H

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsAssert.h>

#include "../mdsBase.h"
#include "../mdsMatrixBase.h"
#include "../mdsLapack.h"
#include "../mdsVector.h"

#include <cmath>


namespace mds
{
namespace math
{

//==============================================================================
/*
 * Global functions.
 */

//! Inplace computation of a square matrix inverse.
//! - Throws warning on failure.
template <class M>
inline void inverse(CMatrixBase<M>& Matrix);


//==============================================================================
/*
 * Functions templates.
 */

// Include file containing methods templates
#include "mdsInverse.hxx"


} // namespace math
} // namespace mds

#endif // MDS_MATRIXFUNCTIONS_INVERSE_H

